% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/framework-ffa.R
\name{framework_ffa}
\alias{framework_ffa}
\title{Orchestrate Flood Frequency Analysis}
\usage{
framework_ffa(
  data,
  years,
  ns_splits = NULL,
  ns_structures = NULL,
  generate_report = TRUE,
  report_path = NULL,
  report_formats = "html",
  ...
)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{years}{Numeric vector of observation years corresponding to \code{data}.
Must be the same length as \code{data} and strictly increasing.}

\item{ns_splits}{An integer vector of years used to split the data into homogeneous
subperiods. For S-FFA, set to \code{NULL} (default). For NS-FFA, specify an \emph{integer} vector
of years with physical justification for change points, or \code{NULL} if no such years exist.
In R, integers have the suffix \code{L}, so \code{1950L} is a valid input to \code{ns_splits}, but \code{1950}
is not (since R may interpret it as a floating point number).}

\item{ns_structures}{For S-FFA, set to \code{NULL} (default) to use a stationary model
for all homogeneous subperiods. For NS-FFA, provide a list of \code{length(ns_splits) + 1}
sublists specifying the nonstationary model structure for each homogeneous subperiod.
Each sublist must contain logical elements \code{location} and \code{scale}, indicating
monotonic trends in the mean and variability, respectively.}

\item{generate_report}{If \code{TRUE} (default), generate a report.}

\item{report_path}{A character scalar, the file path for the generated report.
If \code{NULL} (default), the report will be saved to a new temporary directory.}

\item{report_formats}{A character vector specifying the output format for the
report. Supported values are \code{"md"}, \code{"pdf"}, \code{"html"}, and \code{"json"}.}

\item{...}{Additional arguments. See the "Optional Arguments" section for a complete
list.}
}
\value{
\code{modelling_assumptions}: A list describing the model(s) used for the analysis.
\itemize{
\item \code{approach}: Either "S-FFA", "NS-FFA", or "Piecewise NS-FFA".
\item \code{ns_splits}: The \code{ns_splits} argument, if given.
\item \code{ns_structures}: The \code{ns_structures} argument, if given.
}

\code{submodule_results}: A list of lists of containing the results of frequency analysis.
Each list contains:
\itemize{
\item \code{name}: Either "Distribution Selection", "Parameter Estimation", "Uncertainty
Quantification", or "Model Assessment".
\item \code{start}: The first year of the homogeneous subperiod.
\item \code{end}: The last year of the homogeneous subperiod.
\item Additional items specific to the the submodule.
}
}
\description{
Performs frequency analysis of annual maximum series data including distribution
selection, parameter estimation, uncertainty quantification, and model assessment.
Supports both stationary (S-FFA) or nonstationary (NS-FFA) flood frequency analysis.
}
\section{Optional Arguments}{

\itemize{
\item \code{selection}: Distribution selection method (default is \code{"L-distance"}). Must be
one of \code{"L-distance"}, \code{"L-kurtosis"} or \code{"Z-statistic"}. Alternatively, set
\code{selection} to a three-letter distribution code (e.g., \code{"GUM"}) to use a specific
distribution.
\item \code{s_estimation}: Parameter estimation method for S-FFA (default is \code{"L-moments"}).
Must be \code{"L-moments"}, \code{"MLE"}, or \code{"GMLE"}. Method \code{"GMLE"} requires
\code{selection = "GEV"}.
\item \code{ns_estimation}: Parameter estimation method for NS-FFA (default is \code{"MLE"}).
Must be \code{"MLE"} or \code{"GMLE"}. Method \code{"GMLE"} requires \code{selection = "GEV"}.
\item \code{s_uncertainty}: Uncertainty quantification method for S-FFA (default is
\code{"Bootstrap"}). Must be one of \code{"Bootstrap"}, \code{"RFPL"}, or \verb{RFGPL"}. Using
method \code{"RFPL"} requires \code{s_estimation = "MLE"} and method \code{"RFGPL"} requires
\code{s_estimation = "GMLE"}.
\item \code{ns_uncertainty}: Uncertainty quantification method for NS-FFA (default is
\code{"RFPL"}). Must be one of \code{"Bootstrap"}, \code{"RFPL"}, or \verb{RFGPL"}. Using method
\code{"RFPL"} requires \code{ns_estimation = "MLE"} and method \code{"RFGPL"} requires
\code{ns_estimation = "GMLE"}.
\item \code{z_samples}: Integer number of bootstrap samples for selection method
\code{"Z-statistic"} (default is 10000).
\item \code{gev_prior}: Parameters for the prior distribution of the shape parameter of the
GEV distribution (default is 6, 9). Used with estimation method \code{"GMLE"}.
\item \code{return_periods}: Integer list of return periods (in years) for estimating return
levels. Uses the 2, 5, 10, 20, 50, and 100 year return periods by default.
\item \code{ns_slices}: Integer vector of years at which to estimate the return levels for
nonstationary models. Slices outside of the period will be ignored (default is
1925, 1975, 2025).
\item \code{bootstrap_samples}: Integer number of samples for uncertainty quantification
method `"Bootstrap" (default is 10000).
\item \code{rfpl_tolerance}: Log-likelihood tolerance for uncertainty quantification method
\code{"RFPL"}(default is 0.01).
\item \code{pp_formula}: Plotting position formula for model assessment. Must be one of:
\itemize{
\item "Weibull" (default): \eqn{i / (n + 1)}
\item "Blom": \eqn{(i - 0.375) / (n + 0.25)}
\item "Cunnane": \eqn{(i - 0.4) / (n + 0.2)}
\item "Gringorten": \eqn{(i - 0.44) / (n + 0.12)}
\item "Hazen": \eqn{(i - 0.5) / n}
}
}
}

\seealso{
\code{\link[=select_ldistance]{select_ldistance()}}, \code{\link[=select_lkurtosis]{select_lkurtosis()}}, \code{\link[=select_zstatistic]{select_zstatistic()}},
\code{\link[=fit_lmoments]{fit_lmoments()}}, \code{\link[=fit_mle]{fit_mle()}}, \code{\link[=fit_gmle]{fit_gmle()}}, \code{\link[=uncertainty_bootstrap]{uncertainty_bootstrap()}},
\code{\link[=uncertainty_rfpl]{uncertainty_rfpl()}}, \code{\link[=uncertainty_rfgpl]{uncertainty_rfgpl()}}, \code{\link[=model_assessment]{model_assessment()}}
}
