% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draft.R
\name{draft_recap}
\alias{draft_recap}
\title{Fantasy draft history}
\usage{
draft_recap(leagueId = ffl_id(), leagueHistory = FALSE, ...)
}
\arguments{
\item{leagueId}{Numeric league ID or ESPN fantasy page URL. Defaults to
\code{getOption("fflr.leagueId")}. Function fails if no ID is found.}

\item{leagueHistory}{logical; Should the \code{leagueHistory} version of the API
be called? If \code{TRUE}, a list of results is returned, with one element for
each historical year of the league.}

\item{...}{Additional queries passed to \code{\link[httr:GET]{httr::GET()}}. Arguments are
converted to a named list and passed to \code{query} alongside \code{view}.}
}
\value{
A data frame(s) of draft picks.
}
\description{
Return the sequential result of a fantasy draft pick, whether snake or
salary cap format.
}
\examples{
draft_recap(leagueId = "42654852")
}
\seealso{
Other league functions: 
\code{\link{league_members}()},
\code{\link{league_messages}()},
\code{\link{league_standings}()},
\code{\link{league_status}()},
\code{\link{league_teams}()},
\code{\link{tidy_schedule}()},
\code{\link{transaction_counter}()}
}
\concept{league functions}
