% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_stats.R
\name{empirical_stats}
\alias{empirical_stats}
\alias{empirical_stats.default}
\alias{empirical_stats.numeric}
\alias{empirical_stats.matrix}
\alias{empirical_stats.xts}
\alias{empirical_stats.ts}
\alias{empirical_stats.data.frame}
\alias{empirical_stats.tbl_df}
\title{Summary Statistics for Empirical Distributions}
\usage{
empirical_stats(x, p, level = 0.01)

\method{empirical_stats}{default}(x, p, level = 0.01)

\method{empirical_stats}{numeric}(x, p, level = 0.01)

\method{empirical_stats}{matrix}(x, p, level = 0.01)

\method{empirical_stats}{xts}(x, p, level = 0.01)

\method{empirical_stats}{ts}(x, p, level = 0.01)

\method{empirical_stats}{data.frame}(x, p, level = 0.01)

\method{empirical_stats}{tbl_df}(x, p, level = 0.01)
}
\arguments{
\item{x}{A time series defining the scenario-probability distribution.}

\item{p}{An object of the \code{ffp} class.}

\item{level}{A number with the desired probability level. The default is
\code{level = 0.01}.}
}
\value{
A tidy \code{tibble} with 3 columns:
\itemize{
\item stat: a column with \code{Mu}, \code{Std}, \code{Skew}, \code{Kurt}, \code{VaR} and \code{CVaR}.
\item name: the asset names.
\item value: the computed value for each statistic.
}
}
\description{
Computes the mean, standard deviation, skewness, kurtosis, Value-at-Risk (VaR) and
Conditional Value-at-Risk CVaR) under flexible probabilities.
}
\details{
The data in \code{x} and \code{p} are expected to have the same number of rows
(size).
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(ggplot2)

ret <- diff(log(EuStockMarkets))

# with equal weights (standard scenario)
ew  <- rep(1 / nrow(ret), nrow(ret))
empirical_stats(x = ret, p = as_ffp(ew)) \%>\%
  ggplot(aes(x = name, y = value)) +
  geom_col() +
  facet_wrap(~stat, scales = "free") +
  labs(x = NULL, y = NULL)

# with ffp
exp_smooth <- exp_decay(ret, 0.015)
empirical_stats(ret, exp_smooth) \%>\%
  ggplot(aes(x = name, y = value)) +
  geom_col() +
  facet_wrap(~stat, scales = "free") +
  labs(x = NULL, y = NULL)
}
