% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/originalRcode.R
\name{AFF_scaled_stream_no_change_detection}
\alias{AFF_scaled_stream_no_change_detection}
\title{Compute the adaptive forgetting factor - no change detection}
\usage{
AFF_scaled_stream_no_change_detection(stream, BL, params)
}
\arguments{
\item{stream}{The stream of observations.}

\item{BL}{The burn-in length, used to estimate the mean and variance.}

\item{params}{An \emph{unnamed} list of parameters for the FFF algorithm. 
                Consists of:
             \describe{
                 \item{\code{lambda}}{The value of the fixed forgetting
                                      factor (FFF). Should be in the range 
                                      [0,1].}

                 \item{\code{p}}{The value of the significance threshold, 
                                 which was later renamed \code{alpha} 
                                 (in the paper, not in this function).}
             
                 \item{\code{resettozero}}{A flag; if it zero, then the
                                           ffmean will be reset to zero  
                                           after each change. Usually set 
                                           to 1 (i.e. do not reset).}
             
                 \item{\code{u_init}}{The initial value of \code{u}. 
                                      Should be set to 0.}
             
                 \item{\code{v_init}}{The initial value of \code{v}. 
                                      Should be set to 0.}
             
                 \item{\code{w_init}}{The initial value of \code{w}. 
                                      Should be set to 0.}
             
                 \item{\code{affmean_init}}{The initial value of the 
                                           forgetting factor mean,
                                           \code{ffmean}.
                                           Should be set to 0.}
             
                 \item{\code{affvar_init}}{The initial value of the 
                                           forgetting factor variance, 
                                           \code{ffvar}.
                                           Should be set to 0.}
             
                 \item{\code{low_bound}}{The lower bound for \code{lambda}. 
                                      Usually set to \code{0.6}.}
             
                 \item{\code{up_bound}}{The upper bound for \code{lambda}. 
                                      Usually set to \code{1}.}
             
                 \item{\code{signchosen}}{The sign used in the gradient. 
                                          descent. Usually set to 
                                          \code{-1}.}
             
                 \item{\code{alpha}}{The value of the step size in
                                     the gradient descent step. In
                                     the paper it is referred to
                                     as \eqn{\epsilon}.
                                     Usually \code{0.01}, or otherwise
                                     \code{0.1} or \code{0.001}.}
             
                     }}
}
\value{
A vector with the values of the adaptive forgetting factor
        \eqn{\overrightarrow{\lambda}}.
}
\description{
Original implementation in R of the AFF
}
\keyword{internal}

