% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions.r
\name{km.plot}
\alias{km.plot}
\title{km.plot}
\usage{
km.plot(
  parent.df,
  censor.col = "CENSOR",
  centime.col = "CENTIME.DAY",
  category.col = "REGION",
  category.palette = rainbow(5),
  at.risk.palette = rainbow(5),
  category.label = "Treatment Group",
  nsubj.plot.label = "Number at Risk",
  linetype.palette = 1:6,
  x.label = "Time Since Randomization",
  y.label = "Percetage of Subjects",
  x.limits = c(0, 48),
  x.ticks = seq(0, 48, 3),
  y.ticks = seq(0, 0.01, 0.005),
  y.limits = c(0, 0.01),
  line.size = 0.75,
  fromthetop = FALSE,
  text.size = 4
)
}
\arguments{
\item{parent.df}{data.frame used by ggplot}

\item{censor.col}{name of parent.df column associated with censor variable}

\item{centime.col}{name of parent.df column associated with censored time}

\item{category.col}{data.frame column associated with categorical variable (bar.plot, box.plot, cdf.plot, dot.plot, km.plot)}

\item{category.palette}{colors assoicated with categorical variable}

\item{at.risk.palette}{colors to be assocated with categorical variable in accompanying km.plot generated at.risk table}

\item{category.label}{passed to x-axis label}

\item{nsubj.plot.label}{used in km.plot}

\item{linetype.palette}{values passed to scale_linetype_manual}

\item{x.label}{value gets passed to labs}

\item{y.label}{value gets passed to labs}

\item{x.limits}{value gets passed to scale_x_continuous}

\item{x.ticks}{value gets passed to scale_x_continuous}

\item{y.ticks}{passed to scale_y_continuous}

\item{y.limits}{passed to scale_y_continuous}

\item{line.size}{value gets passed to size within geom_line, geom_step}

\item{fromthetop}{logical. If TRUE KM curve decends from 1, if FALSE KM curve ascends from 0 Ensure you have an appropriate censor.col passed above!}

\item{text.size}{value gets passed to geom_text}
}
\value{
A ggplot object is returned.
}
\description{
A function for creating harmonized Kaplan-Meier plots and accompanying At Risk table.
}
\examples{
{
require(ggplot2); require(gridExtra)
data(km.data)
working.df <- km.data
head(working.df)
km.M <- km.plot(parent.df = subset(working.df, SEX== "M"),
      centime.col = "CENTIME.DAY",
      category.col = "TRTGRP",
      category.palette = c("red", "blue"),
      at.risk.palette = c("red","blue"),              
      linetype.palette = c("solid","dotted"), 
      y.limits=c(0,.01), 
      y.ticks=seq(0,.01,.005), 
      x.limits=c(-3,48),
      x.ticks=seq(0,48,6))
print(km.M[[1]])
print(km.M[[2]])
grid.arrange(km.M[[1]] + theme(legend.position= "bottom"), km.M[[2]], ncol=1)
comeback <- sync.ylab.widths(list(km.M[[1]]+ theme(legend.position= "bottom"), km.M[[2]]))
grid.arrange(comeback[[1]] , comeback[[2]], ncol=1)
build.page(interior.h = c(.8, .2),
      interior.w = c(1),
       ncol=1, nrow=2,
       interior = list(comeback[[1]], 
           comeback[[2]]))
}
}
\seealso{
sync.ylab.widths, nsubj.plot
}
\author{
Greg Cicconetti
}
