% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-get.R
\name{file_get}
\alias{file_get}
\title{Retrieve a file from Filebin}
\usage{
file_get(filename, bin, file = NA, overwrite = FALSE)
}
\arguments{
\item{filename}{File name or URL.}

\item{bin}{Bin name. If \code{NA} the generate random bin name.}

\item{file}{File name to use to save results. If \code{FALSE} then don't save
to file.}

\item{overwrite}{Whether to overwrite existing file.}
}
\value{
Contents of file.
}
\description{
Retrieve a file from Filebin
}
\examples{
\dontrun{
posted <- file_post(LOREM_IPSUM, bin = "latin-text")

# Discard path and just retain filename.
filename <- basename(LOREM_IPSUM)
file_get(filename, "latin-text")

# Delete downloaded file.
file.remove(filename)
}
}
