% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_SoftImpute.R
\name{fill.SoftImpute}
\alias{fill.SoftImpute}
\title{SoftImpute : Spectral Regularization}
\usage{
fill.SoftImpute(A, lambdas = c(10, 1, 0.1), maxiter = 100, tol = 0.001)
}
\arguments{
\item{A}{an \eqn{(n\times p)} partially observed matrix.}

\item{lambdas}{a length-\eqn{t} vector regularization parameters.}

\item{maxiter}{maximum number of iterations to be performed.}

\item{tol}{stopping criterion for an incremental progress.}
}
\value{
a named list containing \describe{
\item{X}{an \eqn{(n\times p\times t)} cubic array after completion at each \code{lambda} value.}
}
}
\description{
\code{fill.SoftImpute} implements convex relaxation techniques to generate
a sequence of regularized low-rank solutions for matrix completion problems.
For the nuclear norm optimization problem, it uses soft thresholding technique
iteratively in that the algorithm returns several matrices in accordance with
the provided vector of regularization parameters \eqn{\lambda} (\code{lambdas}).
}
\examples{
## load image data of 'lena128'
data(lena128)

## transform 5\% of entries into missing
A <- aux.rndmissing(lena128, x=0.05)

## apply the method with 3 lambda values
fill <- fill.SoftImpute(A, lambdas=c(500,100,50))

## visualize
par(mfrow=c(2,2), pty="s")
image(A, col=gray((0:100)/100), axes=FALSE, main="5\% missing")
image(fill$X[,,1], col=gray((0:100)/100), axes=FALSE, main="lambda=500")
image(fill$X[,,2], col=gray((0:100)/100), axes=FALSE, main="lambda=100")
image(fill$X[,,3], col=gray((0:100)/100), axes=FALSE, main="lambda=50")

}
\references{
\insertRef{mazumder_spectral_2010}{filling}
}
\seealso{
\code{\link{fill.HardImpute}}
}
