% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmulti.R
\name{glmmulti}
\alias{glmmulti}
\title{Binomial logistic regression multivariable models: \code{finalfit} model
wrapper}
\usage{
glmmulti(.data, dependent, explanatory)
}
\arguments{
\item{.data}{Dataframe.}

\item{dependent}{Character vector usually of length 1, but can take more than
1 dependent:  name of depdendent variable (must have 2 levels).}

\item{explanatory}{Character vector of any length: name(s) of explanatory
variables.}
}
\value{
A list of multivariable \code{\link[stats]{glm}} fitted model
  outputs. Output is of class \code{glmlist}.
}
\description{
Using \code{finalfit} conventions, produces multiple multivariable binomial
logistic regression models for a set of explanatory variables against a
binary dependent.
}
\details{
Uses \code{\link[stats]{glm}} with \code{finalfit} modelling conventions.
Output can be passed to \code{\link{fit2df}}. Note that this function can
take multiple \code{dependent} variables as well, but performs multiple
individual models, not a multivariate analysis.
}
\examples{
library(finalfit)
library(dplyr)
explanatory = c("age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "mort_5yr"

colon_s \%>\%
	glmmulti(dependent, explanatory) \%>\%
	fit2df(estimate_suffix=" (univariable)")

}
\seealso{
\code{\link{fit2df}, \link{finalfit_merge}}

Other \code{finalfit} model wrappers: \code{\link{coxphmulti}},
  \code{\link{coxphuni}}, \code{\link{glmmixed}},
  \code{\link{glmmulti_boot}}, \code{\link{glmuni}},
  \code{\link{lmmixed}}, \code{\link{lmmulti}},
  \code{\link{lmuni}}
}
\concept{\code{finalfit} model wrappers}
