% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connected-graph-heavy-tail-admm.R
\name{learn_regular_heavytail_graph}
\alias{learn_regular_heavytail_graph}
\title{Laplacian matrix of a connected graph with heavy-tailed data

Computes the Laplacian matrix of a graph on the basis of an observed data matrix,
where we assume the data to be Student-t distributed.}
\usage{
learn_regular_heavytail_graph(
  X,
  heavy_type = "gaussian",
  nu = NULL,
  w0 = "naive",
  d = 1,
  rho = 1,
  update_rho = TRUE,
  maxiter = 10000,
  reltol = 1e-05,
  verbose = TRUE
)
}
\arguments{
\item{X}{an n x p data matrix, where n is the number of observations and p is
the number of nodes in the graph}

\item{heavy_type}{a string which selects the statistical distribution of the data.
Valid values are "gaussian" or "student".}

\item{nu}{the degrees of freedom of the Student-t distribution.
Must be a real number greater than 2.}

\item{w0}{initial vector of graph weights. Either a vector of length p(p-1)/2 or
a string indicating the method to compute an initial value.}

\item{d}{the nodes' degrees. Either a vector or a single value.}

\item{rho}{constraint relaxation hyperparameter.}

\item{update_rho}{whether or not to update rho during the optimization.}

\item{maxiter}{maximum number of iterations.}

\item{reltol}{relative tolerance as a convergence criteria.}

\item{verbose}{whether or not to show a progress bar during the iterations.}
}
\value{
A list containing possibly the following elements:
\item{\code{laplacian}}{estimated Laplacian matrix}
\item{\code{adjacency}}{estimated adjacency matrix}
\item{\code{theta}}{estimated Laplacian matrix slack variable}
\item{\code{maxiter}}{number of iterations taken to reach convergence}
\item{\code{convergence}}{boolean flag to indicate whether or not the optimization conv    erged}
\item{\code{primal_lap_residual}}{primal residual for the Laplacian matrix per iteration}
\item{\code{primal_deg_residual}}{primal residual for the degree vector per iteration}
\item{\code{dual_residual}}{dual residual per iteration}
\item{\code{lagrangian}}{Lagrangian value per iteration}
\item{\code{elapsed_time}}{Time taken to reach convergence}
}
\description{
Laplacian matrix of a connected graph with heavy-tailed data

Computes the Laplacian matrix of a graph on the basis of an observed data matrix,
where we assume the data to be Student-t distributed.
}
