% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_TylerCauchy.R
\name{fit_Tyler}
\alias{fit_Tyler}
\title{Estimate parameters of a multivariate elliptical distribution to fit data via Tyler's method}
\usage{
fit_Tyler(
  X,
  initial = NULL,
  max_iter = 100,
  ptol = 0.001,
  ftol = Inf,
  return_iterates = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{X}{Data matrix containing the multivariate time series (each column is one time series).}

\item{initial}{List of initial values of the parameters for the iterative estimation method.
Possible elements include:
\itemize{\item{\code{mu}: default is the data sample mean,}
         \item{\code{cov}: default is the data sample covariance matrix.}}}

\item{max_iter}{Integer indicating the maximum number of iterations for the iterative estimation
method (default is \code{100}).}

\item{ptol}{Positive number indicating the relative tolerance for the change of the variables
to determine convergence of the iterative method (default is \code{1e-3}).}

\item{ftol}{Positive number indicating the relative tolerance for the change of the log-likelihood
value to determine convergence of the iterative method (default is \code{Inf}, so it is
not active). Note that using this argument might have a computational cost as a convergence
criterion due to the computation of the log-likelihood (especially when \code{X} is high-dimensional).}

\item{return_iterates}{Logical value indicating whether to record the values of the parameters (and possibly the
log-likelihood if \code{ftol < Inf}) at each iteration (default is \code{FALSE}).}

\item{verbose}{Logical value indicating whether to allow the function to print messages (default is \code{FALSE}).}
}
\value{
A list containing possibly the following elements:
        \item{\code{mu}}{Mean vector estimate.}
        \item{\code{cov}}{Covariance matrix estimate.}
        \item{\code{converged}}{Boolean denoting whether the algorithm has converged (\code{TRUE}) or the maximum number
                                of iterations \code{max_iter} has reached (\code{FALSE}).}
        \item{\code{num_iterations}}{Number of iterations executed.}
        \item{\code{cpu_time}}{Elapsed CPU time.}
        \item{\code{log_likelihood}}{Value of log-likelihood after converge of the estimation algorithm (if \code{ftol < Inf}).}
        \item{\code{iterates_record}}{Iterates of the parameters (\code{mu}, \code{scatter},
                                      and possibly \code{log_likelihood} (if \code{ftol < Inf})) along the iterations
                                      (if \code{return_iterates = TRUE}).}
}
\description{
Estimate parameters of a multivariate elliptical distribution, namely, the mean vector
and the covariance matrix, to fit data. Any data sample with NAs will be simply dropped.
The algorithm is based on Tyler's method, which normalizes the centered samples to get rid of
the shape of the distribution tail. The data is first demeaned (with the geometric mean by default)
and normalized. Then the estimation is based on the maximum likelihood estimation (MLE) and the
algorithm is obtained from the majorization-minimization (MM) optimization framework.
Since Tyler's method can only estimate the covariance matrix up to a scaling factor,
a very effective method is employed to recover the scaling factor.
}
\examples{
library(mvtnorm)       # to generate heavy-tailed data
library(fitHeavyTail)

X <- rmvt(n = 1000, df = 6)  # generate Student's t data
fit_Tyler(X)

}
\references{
Ying Sun, Prabhu Babu, and Daniel P. Palomar, “Regularized Tyler’s Scatter Estimator: Existence, Uniqueness, and Algorithms,”
IEEE Trans. on Signal Processing, vol. 62, no. 19, pp. 5143-5156, Oct. 2014.
}
\seealso{
\code{\link{fit_Cauchy}} and \code{\link{fit_mvt}}
}
\author{
Daniel P. Palomar
}
