% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch-squiggle-data.R
\name{fetch_squiggle_data}
\alias{fetch_squiggle_data}
\title{Access Squiggle data using the squiggle API service.}
\usage{
fetch_squiggle_data(
  query,
  ...,
  user_agent = "fitzRoy Package https://github.com/jimmyday12/fitzRoy"
)
}
\arguments{
\item{query}{A text string. The main query to use with the API. Please read the Squiggle documentation for information about valid queries}

\item{...}{(optional) An optional argument provided to the \href{https://api.squiggle.com.au}{Squiggle API}. See details for more info.}

\item{user_agent}{(optional) Use this to set something meaningful so that Squiggle admin can contact you if needed.}
}
\value{
A dataframe, with the resultant data that matches the query specified in \code{query}, as well as any optional filters.
}
\description{
Use \code{fetch_squiggle_data} to access the \href{https://squiggle.com.au}{Squiggle} API. See instructions at \href{https://api.squiggle.com.au}{api.squiggle.com.au}.
}
\details{
Optional arguments can be provided to further restrict the data you are pulling.

For full instructions, see \href{https://api.squiggle.com.au}{api.squiggle.com.au}
}
\examples{
\dontrun{
# Return a list of the sources, with ID's
sources <- fetch_squiggle_data("sources")

# Get tips for Round 1, 2018
tips <- fetch_squiggle_data(query = "tips", round = 1, year = 2018)

# Get tips from Squiggle 2019
squiggle <- fetch_squiggle_data(query = "tips", source = 1, year = 2019)
}
}
