% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-methods.R
\name{pip}
\alias{pip}
\title{Compute Posterior Inclusion Probabilities (PIPs) for rjMCMC Results}
\usage{
pip(results)
}
\arguments{
\item{results}{An object of class rjMCMC containing the output from the \code{rjMCMC} procedure, including the PIP summary for variables.}
}
\value{
A numeric vector with the PIPs for the intercept, treatment, and other variables.
}
\description{
This function returns the posterior inclusion probabilities (PIPs) for all variables,
including the intercept and treatment, based on the results from an rjMCMC model.
}
\examples{
\donttest{
# Example dataset
data("simulated_data")

candsplinevars <- c("X_1")
candbinaryvars <- paste0("Z_", 1:5)
candinter <- c(candsplinevars, candbinaryvars)

mcmc_specs <- list(B = 2000, burnin = 1000, thin = 1, chains = 2, sigma_v = 0.1, bma = TRUE)
prior_params <- list(lambda_1 = 0.1, lambda_2 = 1, a_0 = 0.01, b_0 = 0.01,
                  degree = 3, k_max = 9, w = 1, sigma_B = sqrt(20))

results <- rjMCMC(simulated_data, candsplinevars, candbinaryvars, candinter,
                  mcmc_specs, prior_params)
pip(results)
}
}
