% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table_fill_values.R
\name{fill_values}
\alias{fill_values}
\alias{fill_values.pivot_table}
\title{Fill in missing values}
\usage{
fill_values(pt)

\method{fill_values}{pivot_table}(pt)
}
\arguments{
\item{pt}{A pivot_table object.}
}
\value{
A pivot_table object.
}
\description{
Fills with NA missing values in a pivot table value array.
}
\details{
A pivot table should only contain label rows and columns, and an array of
values, usually numeric data.

To correctly carry out this operation, the number of rows and columns that
contain labels must be defined, and the table must only contain the pivot
table rows and columns.
}
\examples{
library(tidyr)

pt <-
  pt_m4 \%>\%
  remove_top(1) \%>\%
  define_labels(n_col = 2, n_row = 2) \%>\%
  fill_values()

pt <-
  pt_ine2871 \%>\%
  remove_top(6) \%>\%
  remove_bottom(9) \%>\%
  define_labels(n_col = 1, n_row = 2) \%>\%
  fill_values()

}
\keyword{internal}
