% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{highlight}
\alias{highlight}
\title{Text Highlight Color}
\usage{
highlight(x, i = NULL, j = NULL, color = "yellow", part = "body", source = j)
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{color}{color to use as text highlighting color.
If a function, function need to return a character vector of colors.}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}

\item{source}{if color is a function, source is specifying the dataset column to be used
as argument to \code{color}. This is only useful if j is colored with values contained in another
(or other) column.}
}
\description{
change text highlight color of selected rows and
columns of a flextable.
}
\section{Illustrations}{


\if{html}{\figure{fig_highlight_1.png}{options: width="500"}}
}

\examples{
my_color_fun <- function(x){
  out <- rep("yellow", length(x))
  out[x < quantile(x, .75)] <- "pink"
  out[x < quantile(x, .50)] <- "wheat"
  out[x < quantile(x, .25)] <- "gray90"
  out
}
ft <- flextable(head( mtcars, n = 10))
ft <- highlight(ft, j = "disp", i = ~ disp > 200, color = "yellow")
ft <- highlight(ft, j = ~ drat + wt + qsec, color = my_color_fun)
ft
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{fontsize}()},
\code{\link{font}()},
\code{\link{italic}()},
\code{\link{line_spacing}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
