% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_matrix_utils.R
\name{filter_by_length}
\alias{filter_by_length}
\title{Filter Flows by Length}
\usage{
filter_by_length(x, length_min = 0, length_max = Inf)
}
\arguments{
\item{x}{sf object with length_m}

\item{length_min}{minimum length (default 0)}

\item{length_max}{maximum length (default Inf)}
}
\value{
filtered sf object. Flows with length_m outside the specified range are removed.
}
\description{
Filter Flows by Length
}
\examples{
flows <- sf::st_transform(flows_leeds, 3857)
flows <- add_flow_length(flows)
flows <- filter_by_length(flows, length_min = 5000, length_max = 12000)
}
