% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_functions.R
\name{ffi_read_LI850}
\alias{ffi_read_LI850}
\title{Read a LI-850 data file}
\usage{
ffi_read_LI850(file, tz = "UTC")
}
\arguments{
\item{file}{Filename to read, character}

\item{tz}{Time zone of the file's time data, character (optional)}
}
\value{
A \code{\link{data.frame}} with the parsed data, including a
\code{TIMESTAMP} column.
}
\description{
Read a LI-850 data file
}
\examples{
f <- system.file("extdata/LI850.txt", package = "fluxfinder")
dat <- ffi_read_LI850(f)
dat <- ffi_read_LI850(f, tz = "EST") # specify time zone
}
