% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_quality_lm.R
\name{flux_quality_lm}
\alias{flux_quality_lm}
\title{quality assessment for the slopes estimated by flux_fitting}
\usage{
flux_quality_lm(
  slopes_df,
  weird_fluxes_id = c(),
  force_ok_id = c(),
  pvalue_col = "f_pvalue",
  rsquared_col = "f_rsquared",
  pvalue_threshold = 0.3,
  rsquared_threshold = 0.7
)
}
\arguments{
\item{slopes_df}{dataset containing slopes, fluxID, p.value and r.squared}

\item{weird_fluxes_id}{vector of fluxIDs that should be discarded
by the user's decision}

\item{force_ok_id}{vector of fluxIDs for which the user wants to keep
the calculated slope despite a bad quality flag}

\item{pvalue_col}{column containing the p-value of each flux}

\item{rsquared_col}{column containing the r squared to be used for
the quality assessment}

\item{pvalue_threshold}{threshold of p-value below which the change
of gas concentration over time is considered not significant (user decided)}

\item{rsquared_threshold}{threshold of r squared value below which
the linear model is considered an unsatisfactory fit}
}
\value{
same dataframe with added flag and corrected slopes columns
}
\description{
indicates if fluxes should be discarded or replaced by 0
according to parameters set by user.
flux_quality_lm is for the model of the lm family.
flux_quality_exp is for the exponential model.
}
