% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-methods.R
\name{shift}
\alias{shift}
\title{Shifting dates to good dates}
\usage{
shift(dates, period, bdc = "u", calendar = EmptyCalendar(),
  eom_rule = TRUE)
}
\arguments{
\item{dates}{a vector of dates to shift and adjust}

\item{period}{an atomic instance of the \link[lubridate:Period-class]{period
class} in the sense that only one of its slots
should be non-zero. It must also only be a day, month or year period type.}

\item{bdc}{the business day convention used to roll the \code{dates} if necessary
(default: "u" - unadjusted)}

\item{calendar}{an object that inherits from \code{\link{Calendar}} or
\code{\link{JointCalendar}} which is used to determine the goodness of \code{dates}
(default: \code{EmptyCalendar()})}

\item{eom_rule}{if one of the \code{dates} is the last business day of the month,
is being shifted by a month or year \code{period} and \code{eom_rule} is \code{TRUE} then
the shifted date is also the last business day of the month
(default: \code{TRUE})}
}
\value{
a vector of shifted dates
}
\description{
The \code{\link[=adjust]{adjust()}} function rolls dates to the closest good dates. This function
shifts dates by a given \link[lubridate:period]{period} and adjusting the
resulting dates to a closest good dates following the given business day
convention.
}
\examples{
library(lubridate)
ausy <- AUSYCalendar()
shift(ymd("20120229"), months(1), "u", ausy, FALSE)
shift(ymd("20120229"), months(1), "u", ausy, TRUE)
}
\seealso{
Other calendar methods: \code{\link{adjust}},
  \code{\link{generate_schedule}}, \code{\link{is_good}},
  \code{\link{is_valid_bdc}}, \code{\link{is}},
  \code{\link{locale}}, \code{\link{tz}}
}
