% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{geom_fm}
\alias{geom_fm}
\alias{geom_fm.fm_mesh_2d}
\alias{geom_fm.fm_segm}
\alias{geom_fm.fm_mesh_1d}
\title{ggplot2 geomes for fmesher related objects}
\usage{
geom_fm(mapping = NULL, data = NULL, ...)

\method{geom_fm}{fm_mesh_2d}(
  mapping = NULL,
  data = NULL,
  mapping_int = NULL,
  mapping_bnd = NULL,
  defs_int = NULL,
  defs_bnd = NULL,
  ...,
  crs = NULL
)

\method{geom_fm}{fm_segm}(mapping = NULL, data = NULL, ..., crs = NULL)

\method{geom_fm}{fm_mesh_1d}(
  mapping = NULL,
  data = NULL,
  ...,
  xlim = NULL,
  basis = TRUE,
  knots = TRUE,
  derivatives = FALSE,
  weights = NULL
)
}
\arguments{
\item{mapping}{an object for which to generate a geom.}

\item{data}{an object for which to generate a geom.}

\item{...}{Arguments passed on to the geom method.}

\item{mapping_int}{\code{aes} for interior constraint edges.}

\item{mapping_bnd}{\code{aes} for boundary edges.}

\item{defs_int}{additional settings for interior constraint edges.}

\item{defs_bnd}{additional settings for boundary edges.}

\item{crs}{Optional crs to transform the object to before plotting.}

\item{xlim}{numeric 2-vector; specifies the interval for which to compute
functions. Default is \code{data$interval}}

\item{basis}{logical; if \code{TRUE} (default), show the spline basis functions}

\item{knots}{logical; if \code{TRUE} (default), show the spline knot locations}

\item{derivatives}{logical; if \code{TRUE} (not default), draw first order
derivatives instead of function values}

\item{weights}{numeric vector; if provided, draw weighted basis functions and
the resulting weighted sum.}
}
\value{
A combination of \code{ggplot2} geoms.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{geom_fm} is a generic function for generating geomes from various kinds of
\code{fmesher} objects, e.g. \code{fm_segm} and \code{fm_mesh_2d}.
The function invokes particular methods which depend
on the \link{class} of the \code{data} argument.
Requires the \code{ggplot2} package.

Note: \code{geom_fm} is not yet a "proper" \code{ggplot2} geom method; the interface
may therefore change in the future.
}
\section{Methods (by class)}{
\itemize{
\item \code{geom_fm(fm_mesh_2d)}: Converts an \code{\link[=fm_mesh_2d]{fm_mesh_2d()}} object to \code{sf} with \code{\link[=fm_as_sfc]{fm_as_sfc()}} and uses
\code{geom_sf} to visualize the triangles and edges.

\item \code{geom_fm(fm_segm)}: Converts an \code{\link[=fm_segm]{fm_segm()}} object to \code{sf} with \code{\link[=fm_as_sfc]{fm_as_sfc()}} and uses
\code{geom_sf} to visualize it.

\item \code{geom_fm(fm_mesh_1d)}: Evaluates and plots the basis functions defined by an \code{\link[=fm_mesh_1d]{fm_mesh_1d()}} object.

}}
\examples{
\dontshow{if (require("ggplot2", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ggplot() +
  geom_fm(data = fmexample$mesh)
\dontshow{\}) # examplesIf}
\dontshow{if (require("ggplot2", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
m <- fm_mesh_2d(
  cbind(10, 20),
  boundary = fm_extensions(cbind(10, 20), c(25, 65)),
  max.edge = c(2, 5),
  crs = fm_crs("+proj=longlat")
)
ggplot() +
  geom_fm(data = m)
ggplot() +
  geom_fm(data = m, crs = fm_crs("epsg:27700"))
\donttest{
# Compute a mesh vertex based function on a different grid
px <- fm_pixels(fm_transform(m, fm_crs("mollweide_globe")))
px$fun <- fm_evaluate(m,
  loc = px,
  field = sin(m$loc[, 1] / 5) * sin(m$loc[, 2] / 5)
)
ggplot() +
  geom_tile(aes(geometry = geometry, fill = fun),
    data = px,
    stat = "sf_coordinates"
  ) +
  geom_fm(
    data = m, alpha = 0.2, linewidth = 0.05,
    crs = fm_crs("mollweide_globe")
  )
}
\dontshow{\}) # examplesIf}
\dontshow{if (require("ggplot2", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
m <- fm_mesh_1d(c(1, 2, 4, 6, 10), boundary = c("n", "d"), degree = 2)
ggplot() +
  geom_fm(data = m, weights = c(4, 2, 4, -1))
\dontshow{\}) # examplesIf}
\dontshow{if (require("ggplot2", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
m <- fm_mesh_1d(
  c(1, 2, 3, 5, 7),
  boundary = c("dirichlet", "neumann"),
  degree = 2
)
ggplot() +
  geom_fm(data = m)
\dontshow{\}) # examplesIf}
}
