% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdata.R
\name{fdata}
\alias{fdata}
\title{Format a data frame or tibble}
\usage{
fdata(x, ...)
}
\arguments{
\item{x}{A data frame or tibble to be formatted.}

\item{...}{Any follow-on parameters to the format function.}
}
\value{
A new, formatted data frame or tibble with the formats applied.
}
\description{
The \code{fdata} function applies formatting attributes
to the entire data frame.
}
\details{
If formats are assigned to the "format" attributes of the data frame
columns, the \code{fdata} function will apply those formats
to the specified columns, and return a new, formatted data frame. 
Formats can be specified as formatting strings, named vectors, user-defined
formats, or vectorized formatting functions.  The \code{fdata} 
function will
apply the format to the associated column data using the \code{\link{fapply}} 
function. A format can also be specified as a formatting list of the 
previous four types.  See the \code{\link{fapply}}
function for additional information.

After formatting each column, the \code{fdata} function will 
call the base R \code{\link{format}} function on 
the data frame.  Any follow on parameters will be sent to the \code{format}
function.   

The \code{fdata} function will also apply any \code{width} or \code{justify}
attributes assigned to the data frame columns.  These attributes can be 
controlled at the column level.  Using
attributes to assign formatting and \code{fdata} to apply those attributes
gives you a great deal of control over how
your data is presented.
}
\examples{
# Construct data frame from state vectors
df <- data.frame(state = state.abb, area = state.area)[1:10, ]

# Calculate percentages
df$pct <- df$area / sum(state.area) * 100

# Before formatting 
df

#    state   area         pct
# 1     AL  51609  1.42629378
# 2     AK 589757 16.29883824
# 3     AZ 113909  3.14804973
# 4     AR  53104  1.46761040
# 5     CA 158693  4.38572418
# 6     CO 104247  2.88102556
# 7     CT   5009  0.13843139
# 8     DE   2057  0.05684835
# 9     FL  58560  1.61839532
# 10    GA  58876  1.62712846

# Create state name lookup list
name_lookup <- state.name
names(name_lookup) <- state.abb

# Assign formats
formats(df) <- list(state = name_lookup,                         
                    area  = function(x) format(x, big.mark = ","), 
                    pct   = "\%.1f\%\%") 

# Apply formats
fdata(df)

#          state    area   pct
# 1      Alabama  51,609  1.4\%
# 2       Alaska 589,757 16.3\%
# 3      Arizona 113,909  3.1\%
# 4     Arkansas  53,104  1.5\%
# 5   California 158,693  4.4\%
# 6     Colorado 104,247  2.9\%
# 7  Connecticut   5,009  0.1\%
# 8     Delaware   2,057  0.1\%
# 9      Florida  58,560  1.6\%
# 10     Georgia  58,876  1.6\%
}
\seealso{
\code{\link{fcat}} to create a format catalog, 
\code{\link{fapply}} to apply a format to a vector,
\code{\link{value}} to define a format object,
\code{\link{fattr}} to assign formatting specifications to a single 
column/vector, and the
\code{\link{formats}}, \code{\link{widths}}, and \code{\link{justification}}
functions to get or set formatting for an entire data frame.  Also see
\link{FormattingStrings} for documentation on formatting strings.
}
