#' Chronostratigraphic Chart
#'
#' The ICS international chronostratigraphic chart (v2020/03).
#' @format A data frame with 5 variables:
#'  \describe{
#'    \item{unit}{Unit name.}
#'    \item{type}{Unit type ("eon", "era", "period", "epoch" or "age").
#'    Precambrian and Hadean are informal units.}
#'    \item{parent}{Parent unit.}
#'    \item{start}{Lower boundary (Ma).}
#'    \item{end}{Upper boundary (Ma).}
#'  }
#' @references
#'  Cohen, K. M., Finney, S. C., Gibbard, P. L. and Fan, J.-X. (2013).
#'  The ICS International Chronostratigraphic Chart. \emph{Episodes},
#'  36(3): 199-204. \doi{10.18814/epiiugs/2013/v36i3/002}
#' @source
#'  \url{https://stratigraphy.org/ICSchart/ChronostratChart2020-03.pdf}
#' @family chronology
#' @keywords datasets
#' @noRd
#"stratigraphy"
