% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_processing_functions.R
\name{compute_growth}
\alias{compute_growth}
\title{Compute growth of trees}
\usage{
compute_growth(census_1, census_2, id)
}
\arguments{
\item{census_1}{A data frame of the first census.}

\item{census_2}{A data frame of the second (later) census}

\item{id}{Name of variable that uniquely identifies each tree common
to \code{census_1} and \code{census_2} allowing you to join/merge
both data frames.}
}
\value{
An \code{sf} data frame with column \code{growth} giving the average
annual growth in \code{dbh}.
}
\description{
Based on two tree censuses, compute the average annual growth in \code{dbh} for all
trees.
}
\examples{
library(dplyr)
library(stringr)

growth_ex <-
  compute_growth(
    census_1 = census_1_ex \%>\%
      mutate(sp = to_any_case(sp) \%>\% factor()),
    census_2 = census_2_ex \%>\%
      filter(!str_detect(codes, "R")) \%>\%
      mutate(sp = to_any_case(sp) \%>\% factor()),
    id = "ID"
  )
}
\seealso{
Other data processing functions: 
\code{\link{create_bayes_lm_data}()},
\code{\link{create_focal_vs_comp}()}
}
\concept{data processing functions}
