% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_processing_functions.R
\name{create_focal_vs_comp}
\alias{create_focal_vs_comp}
\title{Create focal versus competitor trees data frame}
\usage{
create_focal_vs_comp(growth_df, comp_dist, blocks, id)
}
\arguments{
\item{growth_df}{A \code{\link[=compute_growth]{compute_growth()}} output converted to \code{sf} object}

\item{comp_dist}{Distance to determine which neighboring trees to a focal tree are competitors.}

\item{blocks}{An sf object of a \code{blockCV} block output}

\item{id}{A character string of the variable name in \code{growth_df} uniquely identifying each tree}
}
\value{
\code{focal_vs_comp} data frame of all focal trees and for each focal
tree all possible competitor trees. In particular, for each competitor tree
we compute the \href{https://en.wikipedia.org/wiki/Basal_area}{basal area}
(in meters-squared) based on the \code{dbh1} variable from the first census
(assumed to be in cm).
}
\description{
"Focal versus competitor trees" data frames are the main data
frame used for analysis. "Focal trees" are all trees that satisfy the
following criteria
\enumerate{
\item Were alive at both censuses
\item Were not part of the study region's buffer as computed by \code{\link[=add_buffer_variable]{add_buffer_variable()}}
\item Were not a resprout at the second census. Such trees should be coded as
\code{"R"} in the \code{codes2} variable (OK if a resprout at first census)
}
For each focal tree, "competitor trees" are all trees that (1) were alive at
the first census and (2) within \code{comp_dist} distance of the focal tree.
}
\note{
In order to speed computation, in particular of distances between all
focal/competitor tree pairs, we use the cross-validation \code{blockCV}
object to divide the study region into smaller subsets.
}
\examples{
library(ggplot2)
library(dplyr)
library(stringr)
library(sf)
library(sfheaders)
library(tibble)

# Create fold information sf object.
SpatialBlock_ex <-
  tibble(
    # Study region boundary
    x = c(0, 0, 5, 5),
    y = c(0, 5, 5, 0)
  ) \%>\%
  # Convert to sf object
  sf_polygon() \%>\%
  mutate(folds = "1")

# Plot example data. Observe for comp_dist = 1.5, there are 6 focal vs comp pairs:
# 1. focal 1 vs comp 2
# 2. focal 2 vs comp 1
# 3. focal 2 vs comp 3
# 4. focal 3 vs comp 2
# 5. focal 4 vs comp 5
# 6. focal 5 vs comp 4
ggplot() +
  geom_sf(data = SpatialBlock_ex, fill = "transparent") +
  geom_sf_label(data = growth_toy, aes(label = ID))

# Return corresponding data frame
growth_toy \%>\%
  create_focal_vs_comp(comp_dist = 1.5, blocks = SpatialBlock_ex, id = "ID")

# Load in growth_df with spatial data
# See ?growth_ex for attaching spatial data to growth_df
data(growth_spatial_ex)
# Load in blocks
data(blocks_ex)

focal_vs_comp_ex <- growth_spatial_ex \%>\%
  create_focal_vs_comp(comp_dist = 1, blocks = blocks_ex, id = "ID")
}
\seealso{
Other data processing functions: 
\code{\link{compute_growth}()},
\code{\link{create_bayes_lm_data}()}
}
\concept{data processing functions}
