% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_functions.R
\name{compute_buffer_region}
\alias{compute_buffer_region}
\title{Compute buffer to a region.}
\usage{
compute_buffer_region(region, direction = "in", size)
}
\arguments{
\item{region}{An \code{sf} polygon object of region to be buffered}

\item{direction}{"in" for buffers that are contained within \code{region} (default), "out" for buffers that contain \code{region}.}

\item{size}{Distance to determine which neighboring trees to a focal tree are
competitors. The units are assumed to be the same as the \code{geometry} variables in \code{growth_df}.}
}
\value{
An \code{sf} polygon object of buffer
}
\description{
Compute buffer to a region.
}
\examples{
library(tibble)
library(sfheaders)
library(ggplot2)

# Example square region to be buffered (as sf object)
region <- tibble(
  x = c(0, 0, 1, 1),
  y = c(0, 1, 1, 0)
) \%>\%
  sf_polygon()

# Size of buffer
size <- 0.05

# Compute "inwards" buffer
inwards_buffer_region <- region \%>\%
  compute_buffer_region(direction = "in", size = size)

# Compute "outwards" buffer
outwards_buffer_region <- region \%>\%
  compute_buffer_region(direction = "out", size = size)

# Plot all three regions:
ggplot() +
  geom_sf(data = outwards_buffer_region, col = "blue", fill = "transparent") +
  geom_sf(data = region, fill = "transparent") +
  geom_sf(data = inwards_buffer_region, col = "orange", fill = "transparent") +
  labs(title = "Regions: original (black), inwards buffer (orange), and outwards buffer (blue)")
}
\seealso{
Other spatial functions: 
\code{\link{add_buffer_variable}()},
\code{\link{focal_vs_comp_distance}()}
}
\concept{spatial functions}
