% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onephase.R
\name{onephase}
\alias{onephase}
\title{onephase}
\usage{
onephase(formula, data, phase_id = list(phase.col = NA, terrgrid.id = NA),
  cluster = NA, area = list(sa.col = NA, areas = NA))
}
\arguments{
\item{formula}{an object of class "\code{\link[stats]{formula}}" that
must be of the form \code{Y ~ 1}, where Y is the terrestrial response
value of interest provided in \code{data}.}

\item{data}{a data frame or vector containing the response value Y.
Specifications are given under 'Details'.}

\item{phase_id}{an object of class "\code{\link[base]{list}}" containing two elements:
     \itemize{
          \item \code{phase.col}: the column name in \code{data} that specifies the
                                  phase membership of each observation
          \item \code{terrgrid.id}: the indicator identifying the the terrestrial
                                    (a.k.a. "ground truth") phase for that column
             }
\strong{Note:} Only has to be specified if \code{data} is of class \code{data.frame}.}

\item{cluster}{Specifies the column name in \code{data}
containing the cluster identification. Only used in case of
cluster sampling.}

\item{area}{(\emph{Optional}) an object of class "\code{\link[base]{list}}" containing two elements:
         \itemize{
               \item \code{sa.col}: the column name in \code{data} containing
                                     domain identification
               \item \code{areas}: vector of desired domains for which the estimation
                                   should be computed. If estimations for multiple domains should be computed,
                                   the domains have to be defined within a \code{character} vector using \code{c()}
                 }

           Further details of the parameter-specifications are given under \emph{'Details'}.}
}
\value{
\code{onephase} returns an object of class \code{"onephase"}.

The functions \code{summary} and \code{confint} can be used to obtain a summary of the
estimation results (point estimations, variances and sample sizes) and the confidence intervals
for the respective point estimates.

An object of class \code{"onephase"} returns a \code{list} of the following components:

 \item{input}{a \code{list} containing the function inputs}
 \item{estimation}{a data frame containing the following components:
                  \itemize{
                   \item \code{area:} the domain (only present if argument \code{area} has been used)
                   \item \code{estimate:} the point estimate
                   \item \code{variance:} the variance of the point estimate
                   \item \code{n2:} the terrestrial sample size
                   }}
 \item{samplesizes}{a named numeric vector giving the terrestrial samplesize}
}
\description{
\code{onephase} is used to calculate estimations exclusively based on
terrestrial observations of a forest inventory (i.e. the \emph{local densities}).
The estimation method is available for simple and cluster-sampling
and provides point estimates of the sample mean and their variances.
}
\details{
\code{data} can either be a vector only containing the observations of the
              response variable Y,
              \emph{or} a data frame containing a column for the response variable and
              a column for the sample-grid indication that has to be further specified
              by argument \code{phase_id}.
              Additional \emph{optional} columns include a cluster identification in case of
              cluster sampling, as well as a column that specifies a domain (e.g. a forest district)
              the respective terrestrial observation falls into.
              The latter allows to compute onephase-estimations
              for multiple domains at a time (see \emph{'Examples'}).
}
\examples{
# ----------- non-cluster sampling------------------#

## load grisons dataset:
data(grisons)

## 1) calculate onephase-estimation for entire dataset:
op <- onephase(formula = tvol~1 ,data = grisons,
              phase_id =list(phase.col = "phase_id_2p",terrgrid.id = 2))
summary(op)
confint(op)

## 2) calculate onephase-estimation for given domains (areas) in dataset:
op.a <- onephase(formula = tvol~1,
                 data = grisons,
                 phase_id = list(phase.col = "phase_id_2p", terrgrid.id = 2),
                 area = list(sa.col = "smallarea", areas = c("A", "B")))
summary(op.a)
confint(op.a)

# ----------- cluster sampling ------------------#

## load zurichberg dataset:
data(zberg)

## 1) calculate onephase-estimation for entire dataset:
op.clust <- onephase(formula = basal~1, data = zberg,
                     phase_id = list(phase.col = "phase_id_2p",terrgrid.id = 2),
                     cluster = "cluster")
summary(op.clust)
confint(op.clust)

## 2) calculate onephase-estimation for given areas in dataset:
op.clust.a <- onephase(formula = basal~1,
                       data = zberg,
                       phase_id = list(phase.col = "phase_id_2p", terrgrid.id = 2),
                       cluster = "cluster",
                       area = list(sa.col = "ismallg23", areas = c("2", "3")))
summary(op.clust.a)
confint(op.clust.a)
}
\references{
Mandallaz, D. (2007). \emph{Sampling techniques for forest inventories.} Chapter 4. CRC Press.
}

