% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smalianwob.R
\name{smalianwob}
\alias{smalianwob}
\title{Calculate the volume without bark of trees using the Smalian method}
\usage{
smalianwob(
  df,
  di,
  hi,
  bt,
  tree,
  .groups = NA,
  di_mm_to_cm = FALSE,
  hi_cm_to_m = FALSE,
  bt_mm_to_cm = FALSE
)
}
\arguments{
\item{df}{A data frame.}

\item{di}{Quoted name of the section diameter  variable, in centimeters.}

\item{hi}{Quoted name of the section height  variable, in meters}

\item{bt}{Quoted name of the bark thickness variable, in centimeters.}

\item{tree}{Quoted name of the tree variable. used to differentiate the trees' sections. If this argument is \code{NA}, the defined groups in the data frame will be used. Default: \code{NA}.}

\item{.groups}{Optional argument. Quoted name(s) of additional grouping variables that can be added to differentiate subdivisions of the data. 
If this argument is \code{NA}, the defined groups in the data frame will be used. Default: \code{NA}.}

\item{di_mm_to_cm}{Boolean argument that, if \code{TRUE}, converts the di argument from milliliters to centimeters. Default: \code{FALSE}.}

\item{hi_cm_to_m}{Boolean argument that, if \code{TRUE}, converts the hi argument from centimeters to meters. Default: \code{FALSE}.}

\item{bt_mm_to_cm}{Boolean argument that, if \code{TRUE}, converts the bt argument from milliliters to centimeters. Default: \code{FALSE}.}
}
\value{
Data frame with volume values by section.
}
\description{
Function used to calculate the volume without bark of trees using the Smalian method.
This function has integration with dplyr, so it can be used inside a pipe, along with the
\code{group_by} function.
}
\examples{
library(forestmangr)
data("exfm7")
head(exfm7)

# Calculate the volume without bark using Smalian's method:
smalianwob(exfm7,"di_wb", "hi", "bark_t", "TREE",bt_mm_to_cm=TRUE)

# Using pipes:
library(dplyr)

 exfm7 \%>\% 
 group_by(TREE) \%>\% 
 smalianwob("di_wb", "hi", "bark_t")

}
\references{
Campos, J. C. C. and Leite, H. G. (2017) Mensuracao Florestal: Perguntas e Respostas. 5a. Vicosa: UFV.
}
\seealso{
Complementary functions:
  \code{\link{smalianwb}}, For calculation of volume with bark using the Smalian method,
  \code{\link{huberwb}}, for calculation of volume with bark using the Huber method,
  \code{\link{huberwob}}, for calculation of volume without bark the Huber method.
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
