% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{dplyr_methods}
\alias{dplyr_methods}
\alias{fr_mutate}
\alias{fr_rename}
\alias{fr_select}
\alias{fr_filter}
\alias{fr_summarize}
\alias{fr_arrange}
\title{dplyr methods for fr_tdr objects}
\usage{
fr_mutate(x, ...)

fr_rename(x, ...)

fr_select(x, ...)

fr_filter(x, ...)

fr_summarize(x, ...)

fr_arrange(x, ...)
}
\arguments{
\item{x}{a \code{\link[=fr-package]{fr_tdr}} object}

\item{...}{passed to the underlying dplyr function}
}
\value{
a \code{\link[=fr-package]{fr_tdr}} object
}
\description{
Some basic dplyr functions are re-implemented here for for \code{fr_tdr} objects.
The input is converted with \code{as.data.frame()} before being
passed to the dplyr function. The resulting tibble object is converted back
into a \code{fr_tdr} object, matching table- and field-specific metadata where
possible by using \code{as_fr_tdr()} and specifying the \code{.template} argument.
 \tabular{cc}{
   \strong{dplyr} \tab \strong{fr} \cr
   \code{mutate()} \tab \code{fr_mutate()} \cr
   \code{rename()} \tab \code{fr_rename()} \cr
   \code{select()} \tab \code{fr_select()} \cr
   \code{filter()} \tab \code{fr_filter()} \cr
   \code{summarise()} \tab \code{fr_summarise()} \cr
   \code{arrange()} \tab \code{fr_arrange()} \cr
}
}
\examples{
read_fr_tdr(fs::path_package("fr", "hamilton_poverty_2020")) |>
  fr_mutate(next_year = year + 1) |>
  fr_rename(new_year = next_year) |>
  fr_select(-new_year) |>
  fr_filter(fraction_poverty > 0.1) |>
  fr_summarize(median_poverty_fraction = median(fraction_poverty)) |>
  fr_arrange(median_poverty_fraction)
}
