% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DenFMean.R
\name{DenFMean}
\alias{DenFMean}
\title{Fréchet means of densities.}
\usage{
DenFMean(yin = NULL, hin = NULL, qin = NULL, optns = list())
}
\arguments{
\item{yin}{A matrix or list holding the sample of observations of the response. If \code{yin} is a matrix, each row holds the observations of the response corresponding to a row in \code{xin}.}

\item{hin}{A list holding the histograms of the response corresponding to each row in \code{xin}.}

\item{qin}{A matrix or list holding the quantile functions of the response. If \code{qin} is a matrix, each row holds the quantile function of the response taking values on \code{optns$qSup} corresponding to a row in \code{xin}.}

\item{optns}{A list of options control parameters specified by \code{list(name=value)}.}
}
\value{
A list containing the following components:
\item{dout}{A matrix or list holding the output densities corresponding to \code{xout}. If \code{dout} is a matrix, each row gives a density and the domain grid is given in \code{dSup}. If \code{dout} is a list, each element is a list of two components, \code{x} and \code{y}, giving the domain grid and density function values, respectively.}
\item{dSup}{A numeric vector giving the domain grid of \code{dout} when it is a matrix.}
\item{qout}{A matrix holding the quantile functions of the output densities. Each row corresponds to a value in \code{xout}.}
\item{qSup}{A numeric vector giving the domain grid of \code{qout}.}
\item{optns}{A list of control options used.}
}
\description{
Obtain Fréchet means of densities with respect to \eqn{L^2}-Wasserstein distance.
}
\details{
Available control options are \code{qSup}, \code{nqSup}, \code{lower}, \code{upper}, \code{bwDen}, \code{nRegGrid}, \code{delta}, \code{kernelDen}, \code{infSupport}, \code{outputGrid}. See \code{\link{LocDenReg}} for details.
}
\examples{
xin = seq(0,1,0.05)
yin = lapply(xin, function(x) {
  rnorm(100, rnorm(1,x + x^2,0.005), 0.05)
})
res <- DenFMean(yin=yin)
plot(res)

}
