% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bs4dash.R
\name{bs4dash_button}
\alias{bs4dash_button}
\title{bs4dash buttons variables}
\usage{
bs4dash_button(
  default_background_color = NULL,
  default_color = NULL,
  default_border_color = NULL,
  padding_y_xs = NULL,
  padding_x_xs = NULL,
  line_height_xs = NULL,
  font_size_xs = NULL,
  border_radius_xs = NULL
)
}
\arguments{
\item{default_background_color}{Default background color.}

\item{default_color}{Default color.}

\item{default_border_color}{Default border color.}

\item{padding_y_xs}{Vertical padding for extra small button.}

\item{padding_x_xs}{Horizontal padding for extra small button.}

\item{line_height_xs}{Line height for extra small button.}

\item{font_size_xs}{Font size for extra small button.}

\item{border_radius_xs}{Border radius for extra small button.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
bs4dash buttons variables
}
\examples{

# This will affect default actionButton()
bs4dash_button(
  default_background_color = "#FF0000",
  default_color = "#3ADF00",
  default_border_color = "#3ADF00"
)

if (interactive()) {

  library(shiny)
  library(bs4Dash)

  ui <- bs4DashPage(
    title = "bs4Dash Custom Colors",
    navbar = bs4DashNavbar(),
    sidebar = bs4DashSidebar(),
    body = bs4DashBody(

      use_theme(create_theme(
        bs4dash_button(
          default_background_color = "#FF0000",
          default_color = "#3ADF00",
          default_border_color = "#3ADF00"
        )
      )),

      actionButton(
        "btn",
        "An action button",
        icon("rocket")
      )
    )
  )

  server <- function(input, output) {

  }

  shinyApp(ui, server)

}
}
