% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hourly_RH.R
\name{hourly_RH}
\alias{hourly_RH}
\title{Estimation of the hourly relative humidity on a daily series}
\usage{
hourly_RH(climdata, lat)
}
\arguments{
\item{climdata}{a dataframe with daily temperatures and RH for
each day in a series. Must contain the columns Year, Month, Day,
Tmax, Tmin, RHmax (daily maximum relative humidity) and RHmin
(minimum daily relative humidity).}

\item{lat}{the latitude of the site, in decimal degrees.}
}
\value{
dataframe with columns Date, Year, Month, Day, DOY,
Hour, Temp and RH
}
\description{
This function estimates the hourly relative humidity (RH),
using daily temperature and humidity data. Hourly humidity is
estimated with the formula proposed by Waichler and Wigmosta (2003)
which require maximum and minimum values of daily temperature
and relative humidity.
}
\examples{

# Generate hourly relative humidity
library(tidyverse)
library(lubridate)
Tudela_HRH <- hourly_RH(Tudela_DW, 42.13132)

}
\references{
Waichler SR and Wigmosta MS, 2003. Development of hourly meteorological
values from daily data and significance to hydrological modeling at H.J.
Andrews experimental forest. Journal of Hydrometeorology 4, 251-263.
}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
