% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_meshes.R
\name{vis.coloredmeshes}
\alias{vis.coloredmeshes}
\title{Visualize a list of colored meshes in a single scene.}
\usage{
vis.coloredmeshes(coloredmeshes, background = "white",
  skip_all_na = TRUE, style = "default", rgloptions = list())
}
\arguments{
\item{coloredmeshes, }{list of coloredmesh. A coloredmesh is a named list as returned by the coloredmesh.from.* functions. It has the entries 'mesh' of type tmesh3d, a 'col', which is a color specification for such a mesh.}

\item{background}{string, background color passed to rgl::bg3d()}

\item{skip_all_na}{logical, whether to skip (i.e., not render) meshes in the list that have the property 'morph_data_was_all_na' set to TRUE. Defaults to TRUE. Practically, this means that a hemisphere for which the data was not given is not rendered, instead of being rendered in a single color.}

\item{style, }{a named list of style parameters or a string specifying an available style by name (e.g., 'shiny'). Defaults to 'default', the default style.}

\item{rgloptions}{option list passed to [rgl::par3d()]. Example: rgloptions = list("windowRect"=c(50,50,1000,1000));}
}
\value{
the list of visualized coloredmeshes
}
\description{
Visualize a list of colored meshes in a single scene.
}
\keyword{internal}
