% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_surface_background.R
\name{collayers.merge}
\alias{collayers.merge}
\title{Merge two or more color layers based on their transparency values.}
\usage{
collayers.merge(collayers, opaque_background = "#FFFFFF")
}
\arguments{
\item{collayers}{named list, the values must be vectors, matrices or arrays of color strings (as produced by \code{\link[grDevices]{rgb}}. The names are free form and do not really matter. All values must have the same length.}

\item{opaque_background}{a single color string or `NULL`. If a color string, this color will be used as a final opaque background layer to ensure that the returned colors are all opaque. Pass `NULL` to skip this, which may result in a return value that contains non-opaque color values.}
}
\value{
a color layer, i.e., vector of color strings in a hemilist
}
\description{
Merge several color layers into one based on their transparency and alpha blending. In the final result, the lower layers are visible through the transparent or `NA` parts (if any) of the upper layers.
}
\seealso{
Other surface color layer: 
\code{\link{collayer.bg.atlas}()},
\code{\link{collayer.bg.meancurv}()},
\code{\link{collayer.bg.sulc}()},
\code{\link{collayer.bg}()},
\code{\link{collayer.from.annotdata}()},
\code{\link{collayer.from.annot}()},
\code{\link{collayer.from.mask.data}()},
\code{\link{collayer.from.morphlike.data}()}
}
\concept{surface color layer}
