% Generated by roxygen2 (4.0.1): do not edit by hand
\name{fslfill}
\alias{fslfill}
\title{Fill image holes}
\usage{
fslfill(file, outfile = NULL, bin = TRUE, retimg = FALSE,
  reorient = FALSE, intern = TRUE, ...)
}
\arguments{
\item{file}{(character) filename of image to be filled}

\item{outfile}{(character) name of resultant filled file}

\item{bin}{(logical) binarize the image before filling}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link{readNIfTI}}.}

\item{intern}{(logical) pass to \code{\link{system}}}

\item{...}{additional arguments passed to \code{\link{readNIfTI}}.}
}
\value{
character or logical depending on intern
}
\description{
This function calls \code{fslmaths -fillh} to fill in image holes
and either saves the image or returns an object of class nifti
}
\examples{
if (have.fsl()){
system.time({
x = array(rnorm(1e6), dim = c(100, 100, 100))
img = nifti(x, dim= c(100, 100, 100),
datatype = convert.datatype()$FLOAT32, cal.min = min(x),
cal.max = max(x), pixdim = rep(1, 4))
mask = img > .5
eroded = fslerode(mask, kopts = "-kernel boxv 5", retimg=TRUE)
filled = fslfill(eroded, retimg= TRUE)
})
}
}

