% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsi_functions.R
\name{fsi_add_rules}
\alias{fsi_add_rules}
\title{Adding fuzzy rules to an FSI model}
\usage{
fsi_add_rules(fsi, rules, weights = rep(1, length(rules)))
}
\arguments{
\item{fsi}{An FSI model instantiated with the function \code{fsi_create}.}

\item{rules}{A character vector containing the rules defined by the user. It follows a specific format, as detailed below.}

\item{weights}{A numeric vector of weight values for each rule. Default values are 1.}
}
\value{
An FSI model populated with fuzzy rules set.
}
\description{
This function adds the fuzzy rules set to a fuzzy spatial inference (FSI) model. A fuzzy rule must contain only linguistic variables and values employed by the added antecedent parts and consequent.
}
\details{
The definition of a fuzzy rule is user-friendly since users can write it by using the \emph{linguistic variables} and \emph{linguistic values} previously defined and added to the FSI model.
A fuzzy rule has the format \verb{IF A THEN B}, where \code{A} is called the antecedent and \code{B} the consequent of the rule such that \code{A} implies \code{B}.  Further, \code{A} and \code{B} are statements that combine fuzzy propositions by using logical connectives like \code{AND} or \code{OR}. Each fuzzy proposition has the format \verb{LVar is LVal} where \code{LVal} is a linguistic value in the scope of the linguistic variable \code{LVar}.
To avoid possible contradictions keep in mind the following items when specifying the rules:
\itemize{
\item the order of the statements in the antecedent is not relevant;
\item each linguistic variable has to appear at most one time in each fuzzy rule;
}
}
\examples{

# Creating the FSI model from an example implemented with the visitation function:
fsi <- visitation()

# Creating a vector of fuzzy rules; 
## note that we make use of the linguistic variables and linguistic values previously defined:
rules <- c(
  "IF accommodation review is reasonable AND food safety is low 
  THEN visiting experience is awful",
 "IF accommodation price is expensive AND accommodation review is reasonable 
   THEN visiting experience is awful",
 "IF accommodation price is affordable AND accommodation review is good AND food safety is medium 
   THEN visiting experience is average",
 "IF accommodation price is affordable AND accommodation review is excellent 
                                                                AND food safety is high 
   THEN visiting experience is great",
 "IF accommodation price is cut-rate AND accommodation review is excellent AND food safety is high 
   THEN visiting experience is great")

# Adding these rules to the FSI model previously instantiated:
fsi <- fsi_add_rules(fsi, rules)

}
