% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_operations.R
\name{spa_core}
\alias{spa_core}
\title{Get the core of a \code{pgeometry} object}
\usage{
spa_core(pgo)
}
\arguments{
\item{pgo}{A \code{pgeometry} object of any type.}
}
\value{
An \code{sfg} object that represents the core of \code{pgo}. It can be an empty object, if \code{pgo} does not have a component with membership degree 1.
}
\description{
\code{spa_core()} yields a crisp spatial object (as an \code{sfg} object) that corresponds to the core of a \code{pgeometry} object given as input.
}
\details{
The \code{spa_core()} function employs the classical definition of \emph{core} from the fuzzy set theory in the context of Spatial Plateau Algebra.
The \emph{core} only comprises the points with membership degree equal to 1.
Hence, this operation returns the \code{sfg} object that represents the component labeled with
membership degree equal to 1 of the \code{pgeometry} object given as input. If the \code{pgeometry} object has no core, then an empty \code{sfg} object is returned.
}
\examples{
pcp1 <- create_component("POINT(0 0)", 0.3)
pcp2 <- create_component("MULTIPOINT((2 2), (2 4), (2 0))", 0.5)
pcp3 <- create_component("MULTIPOINT((1 1), (3 1), (1 3), (3 3))", 0.9)
pcp4 <- create_component("MULTIPOINT((1 2), (2 1), (3 2))", 1)
pcp5 <- create_component("MULTIPOINT((0 0.5), (2 3))", 0.7)
pcp6 <- create_component("MULTIPOINT((0 1), (3 3.5))", 0.85)
pcp7 <- create_component("MULTIPOINT((1 0), (4 2))", 0.4)

# Creating a plateau point object
ppoint <- create_pgeometry(list(pcp1, pcp2, pcp3, pcp4, pcp5), "PLATEAUPOINT")
ppoint

# Getting its core
spa_core(ppoint)

# Getting the core of an empty pgeometry
spa_core(create_empty_pgeometry("PLATEAUREGION"))
}
\references{
\href{https://onlinelibrary.wiley.com/doi/10.1111/tgis.13044}{Carniel, A. C.; Venâncio, P. V. A. B; Schneider, M. fsr: An R package for fuzzy spatial data handling. Transactions in GIS, vol. 27, no. 3, pp. 900-927, 2023.}

Underlying concepts and formal definitions of Spatial Plateau Algebra are introduced in:
\itemize{
\item \href{https://ieeexplore.ieee.org/document/8491565}{Carniel, A. C.; Schneider, M. Spatial Plateau Algebra: An Executable Type System for Fuzzy Spatial Data Types. In Proceedings of the 2018 IEEE International Conference on Fuzzy Systems (FUZZ-IEEE 2018), pp. 1-8, 2018.}
}
}
