% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_topological_relations.R
\name{spa_exact_equal}
\alias{spa_exact_equal}
\title{Check two spatial plateau objects for exact equality}
\usage{
spa_exact_equal(pgo1, pgo2)
}
\arguments{
\item{pgo1}{A \code{pgeometry} object that is either a plateau point, plateau line, or plateau region object.}

\item{pgo2}{A \code{pgeometry} object that is either a plateau point, plateau line, or plateau region object.}
}
\value{
A Boolean value that indicates if two \code{pgeometry} objects are exactly equal.
}
\description{
\code{spa_exact_equal()} checks whether two spatial plateau objects are exactly equal.
}
\details{
\code{spa_exact_equal()} is a Boolean function that checks \emph{fuzzy equality} in the spatial plateau context. Two \code{pgeometry} objects are exactly equal if their components are equal.
Two components are equal if they have the same membership degree and they are (spatially) equal (i.e., their \code{sfg} objects have the same geometric format - this means that the order of the points can be different).
}
\examples{
pcp1 <- create_component("MULTIPOINT((2 2), (2 4), (2 0))", 0.5)
pcp2 <- create_component("MULTIPOINT((1 1), (3 1), (1 3), (3 3))", 0.9)
pcp3 <- create_component("MULTIPOINT((10 10), (9 8), (7 7))", 1)
pcp4 <- create_component("MULTIPOINT((0 0), (2 3))", 0.7)

ppoint1 <- create_pgeometry(list(pcp1, pcp2), "PLATEAUPOINT")
ppoint2 <- create_pgeometry(list(pcp3, pcp4), "PLATEAUPOINT")

spa_exact_equal(ppoint1, ppoint2)

spa_exact_equal(ppoint1, ppoint1)
}
\references{
\href{https://ieeexplore.ieee.org/document/8491565}{Carniel, A. C.; Schneider, M. Spatial Plateau Algebra: An Executable Type System for Fuzzy Spatial Data Types. In Proceedings of the 2018 IEEE International Conference on Fuzzy Systems (FUZZ-IEEE 2018), pp. 1-8, 2018.}
}
