% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ft_abstract.R
\name{ft_abstract}
\alias{ft_abstract}
\alias{ft_abstract_ls}
\title{Get abstracts}
\usage{
ft_abstract(
  x,
  from = "crossref",
  plosopts = list(),
  scopusopts = list(),
  maopts = list(),
  crossrefopts = list(),
  ...
)

ft_abstract_ls()
}
\arguments{
\item{x}{(character) DOIs as a character vector. See Details.}

\item{from}{Source to query. One or more of crossref (default), plos,
scopus, microsoft, or semanticscholar}

\item{plosopts}{PLOS options, a named list.}

\item{scopusopts}{Scopus options, a named list.}

\item{maopts}{Microsoft Academic options, a named list.}

\item{crossrefopts}{Crossref options, a named list.}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}, see
examples below}
}
\value{
An object of class \code{ft_abstract}
}
\description{
Get abstracts
}
\details{
See \strong{Rate Limits} and \strong{Authentication} in
\link{fulltext-package} for rate limiting and authentication information,
respectively. In particular take int account Semantic Scholar rate limits
because we do asynchronous requests to Semantic Scholar, which means
you can get data fast, but you'll hit your rate limit fast too.

There's no options to pass on when \code{from="semanticscholar"}, other than
curl options via \code{...}

When \code{from="semanticscholar"}, ids passed to \code{x} can be various types: DOI,
S2 paper id (Semantic Scholar id), arXiv id, MAG id, ACL id, PubMed id,
or Corpus id. If you use DOIs or S2 paper ids you can pass them to \code{x}
as is. However, if you use other id types you need to prefix each id
with the name of the type of id, options are: "arXiv", "MAG", "ACL",
"PMID", "CorpusID"
}
\examples{
# List publishers included
ft_abstract_ls()

\dontrun{
# PLOS
## search
(res <- ft_search(query = 'biology', from = 'plos', limit = 25,
   plosopts = list(fq = list('doc_type:full', '-article_type:correction',
                  '-article_type:viewpoints'))))
## get abstracts
dois <- res$plos$data$id
(out <- ft_abstract(x = dois, from = "plos"))
out$plos

# Semantic Scholar
(out <- ft_abstract(x = dois, from = "semanticscholar"))
out$semanticscholar
## using arxiv ids
arxiv_ids <- c("0710.3491", "0804.0713", "0810.4821", "1003.0315")
(out <- ft_abstract(x = paste0("arXiv:", arxiv_ids), from = "semanticscholar"))
out$semanticscholar

# Scopus
opts <- list(key = Sys.getenv('ELSEVIER_SCOPUS_KEY'))

## search
(res <- ft_search(query = 'biology', from = 'scopus', scopusopts = opts,
  limit = 25))
## get abstract
dois <- na.omit(res$scopus$data$`prism:doi`)
out <- ft_abstract(x = dois[1:3], from = "scopus", scopusopts = opts)
out
out$scopus

# use scopus Ids
(res <- ft_search(query = 'biology', from = 'scopus', scopusopts = opts,
  limit = 50))
ids <- fulltext:::strextract(res$scopus$data$`dc:identifier`, "[0-9]+")
(out <- ft_abstract(x = ids[1:4], from = 'scopus',
  scopusopts = list(
    key = Sys.getenv('ELSEVIER_SCOPUS_KEY'),
    id_type = "scopus_id"
  )
))

# Microsoft
key <- Sys.getenv("MICROSOFT_ACADEMIC_KEY")
(res <- ft_search("Y=[2010, 2012)", from = "microsoft",
  maopts = list(key = key)))
ids <- res$ma$data$Id
(out <- ft_abstract(x = ids, from = "microsoft",
  maopts = list(
    key = Sys.getenv('MICROSOFT_ACADEMIC_KEY')
  )
))
out$ma
cat(unlist(lapply(out$ma, "[[", "abstract")), sep = "\n\n")

# Crossref
(res <- ft_search("ecology", from = "crossref",
  crossrefopts = list(filter = c(has_abstract = TRUE))))
ids <- res$crossref$data$doi
(out <- ft_abstract(x = ids, from = "crossref"))
out$crossref

# curl options
ft_abstract("10.2458/v17i1.21696", from = "crossref", verbose = TRUE)
ft_abstract("10.1371/journal.pcbi.1002487", from = "plos", verbose = TRUE)
}
}
