% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_plottingFunctions.R
\name{plotSims}
\alias{plotSims}
\title{Plot for simulations of random processes}
\usage{
plotSims(model, sims, ...)
}
\arguments{
\item{model}{a model object for which the plot is to be made.}

\item{sims}{data structure containing simulations Depending on the type of model and the data structure
used, it might also contain, for instance, the mean and confidence bands at the simulation points.}

\item{...}{additional arguments affecting the plot.}
}
\value{
None.
}
\description{
This method displays the simulated output values delivered by some random process model.
  The plot might be constituted differently, depending on the type of model at hand.
}
\examples{
require(funGp) # a package with a plotSims method implemented
# building the model
set.seed(100)
n.tr <- 25
sIn <- expand.grid(x1 = seq(0,1,length = sqrt(n.tr)), x2 = seq(0,1,length = sqrt(n.tr)))
fIn <- list(f1 = matrix(runif(n.tr*10), ncol = 10), f2 = matrix(runif(n.tr*22), ncol = 22))
sOut <- fgp_BB3(sIn, fIn, n.tr)
m1 <- fgpm(sIn = sIn, fIn = fIn, sOut = sOut)

# making simulations
n.sm <- 100
sIn.sm <- as.matrix(expand.grid(x1 = seq(0,1,length = sqrt(n.sm)),
                                x2 = seq(0,1,length = sqrt(n.sm))))
fIn.sm <- list(f1 = matrix(runif(n.sm*10), ncol = 10), matrix(runif(n.sm*22), ncol = 22))
m1.sims <- simulate(m1, nsim = 10, sIn.sm = sIn.sm, fIn.sm = fIn.sm)

# plotting simulations
plotSims(m1, m1.sims)

}
\seealso{
\strong{*} \link[funGp]{plotSims} for the simulations plot of a funGp model.
}
\keyword{internal}
