% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cross_plot.R
\name{cross_plot}
\alias{cross_plot}
\title{Cross-plotting input variable vs. target variable}
\usage{
cross_plot(data, str_input, str_target, path_out, auto_binning,
  plot_type = "both")
}
\arguments{
\item{data}{data frame source}

\item{str_input}{string input variable (if empty, it runs for all numeric variable), it can take a single character value or a character vector.}

\item{str_target}{string of the variable to predict}

\item{path_out}{path directory, if it has a value the plot is saved}

\item{auto_binning}{indicates the automatic binning of str_input variable based on equal frequency (function 'equal_freq'), default value=TRUE}

\item{plot_type}{indicates if the output is the 'percentual' plot, the 'quantity' or 'both' (default).}
}
\value{
cross plot
}
\description{
The cross_plot shows how the input variable is correlated with the target variable, getting the likelihood rates for each input's bin/bucket .
}
\examples{
\dontrun{
## Example 1:
cross_plot(data=heart_disease, str_input="chest_pain", str_target="has_heart_disease")

## Example 2: Disabling auto_binning:
cross_plot(data=heart_disease, str_input="oldpeak",
		str_target="has_heart_disease", auto_binning=FALSE)

## Example 3: Saving the plot into a folder:
cross_plot(data=heart_disease, str_input="oldpeak",
		str_target="has_heart_disease", path_out = "my_folder")

## Example 4: Running with multiple input variables at the same time:
cross_plot(data=heart_disease, str_input=c("age", "oldpeak", "max_heart_rate"),
		str_target="has_heart_disease")
}
}

