% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{geom_mfd}
\alias{geom_mfd}
\title{Creates a geom layer to plot a Multivariate Functional Data Object
with \code{ggplot}}
\usage{
geom_mfd(
  mapping = NULL,
  data = NULL,
  mfdobj,
  stat = "identity",
  position = "identity",
  na.rm = TRUE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE,
  type_mfd = "mfd",
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings additional
to \code{x} and \code{y} as passed to the function \code{ggplot2::geom:line}.}

\item{data}{A \code{data.frame} providing columns
to create additional aesthetic mappings.
It must contain a column "id" with the replication values
as in \code{mfdobj$fdnames[[2]]}.
If it contains a column "var", this must contain
the functional variables as in \code{mfdobj$fdnames[[3]]}.}

\item{mfdobj}{A multivariate functional data object of class mfd.}

\item{stat}{See \code{ggplot2::\link[ggplot2]{geom_line}}.}

\item{position}{See \code{ggplot2::\link[ggplot2]{geom_line}}.}

\item{na.rm}{See \code{ggplot2::\link[ggplot2]{geom_line}}.}

\item{orientation}{See \code{ggplot2::\link[ggplot2]{geom_line}}.}

\item{show.legend}{See \code{ggplot2::\link[ggplot2]{geom_line}}.}

\item{inherit.aes}{See \code{ggplot2::\link[ggplot2]{geom_line}}.}

\item{type_mfd}{A character value equal to "mfd" or "raw".
If "mfd", the smoothed functional data are plotted, if "raw",
the original discrete data are plotted.}

\item{...}{See \code{ggplot2::\link[ggplot2]{geom_line}}.}
}
\value{
A geom_line layer to be added to
\code{ggplot2::\link[ggplot2]{ggplot}()}
in order to plot \code{mfdobj}.
}
\description{
Creates a geom layer to plot a Multivariate Functional Data Object
with \code{ggplot}
}
\examples{
library(funcharts)
mfdobj <- data_sim_mfd()
ids <- mfdobj$fdnames[[2]]
df <- data.frame(id = ids, first_two_obs = ids \%in\% c("rep1", "rep2"))
ggplot() +
  geom_mfd(mapping = aes(colour = first_two_obs),
           data = df,
           mfdobj = mfdobj)

}
