% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_mfd}
\alias{simulate_mfd}
\title{Simulate a data set for funcharts}
\usage{
simulate_mfd(
  nobs = 1000,
  R2 = 0.97,
  seed,
  shift_type_y = "0",
  shift_type_x1 = "0",
  shift_type_x2 = "0",
  shift_type_x3 = "0",
  d_y = 0,
  d_x1 = 0,
  d_x2 = 0,
  d_x3 = 0,
  d_y_scalar = 0,
  save_beta = FALSE
)
}
\arguments{
\item{nobs}{The number of observation to simulate}

\item{R2}{The desired coefficient of determination in the regression.
In both the scalar and functional response cases, only three values are allowed,
i.e. 0.97, 0.86, 0.74.
Default is 0.97.}

\item{seed}{Deprecated: use \code{set.seed()} before calling
the function for reproducibility.}

\item{shift_type_y}{The shift type for the functional response.
There are five possibilities: "0" if there is no shift,
"A", "B", "C" or "D" for the corresponding shift types
shown in Centofanti et al. (2021).
Default is "0".}

\item{shift_type_x1}{#' The shift type for the first functional covariate.
There are five possibilities: "0" if there is no shift,
"A", "B", "C" or "D" for the corresponding shift types
shown in Centofanti et al. (2021).
Default is "0".}

\item{shift_type_x2}{#' The shift type for the second functional covariate.
#' There are five possibilities: "0" if there is no shift,
"A", "B", "C" or "D" for the corresponding shift types
shown in Centofanti et al. (2021).
Default is "0".}

\item{shift_type_x3}{#' The shift type for the third functional covariate.
#' There are five possibilities: "0" if there is no shift,
"A", "B", "C" or "D" for the corresponding shift types
shown in Centofanti et al. (2021).
Default is "0".}

\item{d_y}{A number indicating the severity of the shift type for the functional response.
Default is 0.}

\item{d_x1}{A number indicating the severity of the shift type for the first functional covariate.
Default is 0.}

\item{d_x2}{A number indicating the severity of the shift type for the second functional covariate.
Default is 0.}

\item{d_x3}{A number indicating the severity of the shift type for the third functional covariate.
Default is 0.}

\item{d_y_scalar}{A number indicating the severity of the shift type for the scalar response.
Default is 0.}

\item{save_beta}{If TRUE, the true regression coefficients of both the function-on-function
and the scalar-on-function models are saved.
Default is FALSE.}
}
\value{
A list with the following elements:

* \code{X1} is a \code{nobs}x150 matrix with the simulated observations of the first functional covariate

* \code{X2} is a \code{nobs}x150 matrix with the simulated observations of the second functional covariate

* \code{X3} is a \code{nobs}x150 matrix with the simulated observations of the third functional covariate

* \code{Y} is a \code{nobs}x150 matrix with the simulated observations of the functional response

* \code{y_scalar} is a vector of length 150 with the simulated observations of the scalar response

* \code{beta_fof}, if \code{save_beta = TRUE}, is a list of three 500x500 matrices
with the discretized functional coefficients of the function-on-function regression

* \code{beta_sof}, if \code{save_beta = TRUE}, is a list of three vectors of length 500
with the discretized functional coefficients of the scalar-on-function regression
}
\description{
Function used to simulate a data set to illustrate the use of \code{funcharts}.
It creates a data set with three functional covariates,
a functional response generated as a function of the three functional covariates
through a function-on-function linear model,
and a scalar response generated as a function of the three functional covariates
through a scalar-on-function linear model.
This function covers the simulation study in Centofanti et al. (2021)
for the function-on-function case and also simulates data in a similar way
for the scalar response case.
In the default case, the function generates in-control data.
Additional arguments can be used to generate additional data that are out of control,
with mean shifts according to the scenarios proposed by Centofanti et al. (2021).
Each simulated observation of a functional variable consists of
a vector of 150 discrete points, equally spaced between 0 and 1, generated with noise.
}
\references{
Centofanti F, Lepore A, Menafoglio A, Palumbo B, Vantini S. (2021)
Functional Regression Control Chart.
\emph{Technometrics}, 63(3), 281--294. <doi:10.1080/00401706.2020.1753581>
}
