% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{tensor_product_mfd}
\alias{tensor_product_mfd}
\title{Tensor product of two Multivariate Functional Data objects}
\usage{
tensor_product_mfd(mfdobj1, mfdobj2 = NULL)
}
\arguments{
\item{mfdobj1}{A multivariate functional data object, of class \code{mfd},
having only one functional observation.}

\item{mfdobj2}{A multivariate functional data object, of class \code{mfd},
having only one functional observation.
If NULL, it is set equal to \code{mfdobj1}. Default is NULL.}
}
\value{
An object of class \code{bifd}.
If we denote with x(s)=(x_1(s),\dots,x_p(s))
the vector of p functions represented by \code{mfdobj1} and
with y(t)=(y_1(t),\dots,y_q(t)) the vector of q functions
represented by \code{mfdobj2},
the output is the
vector of pq bivariate functions

f(s,t)=(x_1(s)y_1(t),\dots,x_1(s)y_q(t),
\dots,x_p(s)y_1(t),\dots,x_p(s)y_q(t)).
}
\description{
This function returns the tensor product of two
Multivariate Functional Data objects.
Each object must contain only one replication.
}
\examples{
library(funcharts)
mfdobj1 <- data_sim_mfd(nobs = 1, nvar = 3)
mfdobj2 <- data_sim_mfd(nobs = 1, nvar = 2)
tensor_product_mfd(mfdobj1)
tensor_product_mfd(mfdobj1, mfdobj2)

}
