% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fclust.R
\name{plot_motifs_box}
\alias{plot_motifs_box}
\title{Plot performances of assembly motifs}
\usage{
plot_motifs_box(fobs, assMotif, sres,
                ordre    = NULL,
                xylim    = range(fobs),
                main     = "",
                xlabel   = "",
                pvalue   = fpvalue(),
                opt.mean = "amean",
                opt.hor  = TRUE)
}
\arguments{
\item{fobs}{numeric vector.
The vector contains assemblage performances.}

\item{assMotif}{an integer vector of \code{length(fobs)}.
The vector contains the labels of each assemblages.
The labels are used to sorted the assemblages
that share a same assembly motif.}

\item{sres}{a table generated by the function \code{\link{sort_motifs}}.
The table contains statistical properties of assembly motifs,
sorted by increasing or decreasing mean performances.}

\item{ordre}{an integer vector of \code{length(fobs)}.
The vector contains labels for each assemblages,
that determine the order for assembly motifs.}

\item{xylim}{a vector of two numerics.
The numerics are extrem values of performance \code{y-axis}.}

\item{main}{a string. The string is used as graph title.}

\item{xlabel}{a string. The string is used as label for abscissa (xlab).}

\item{pvalue}{a probability,
used as threshold
in the variance analysis. Then \code{pvalue} must be
higher than \code{0} and lower than \code{1}.
Groups significantly different
(at a p-value < \code{pvalue}) are then indicated by differents letters
on the right of boxplots.}

\item{opt.mean}{a character equals to \code{"amean"} or \code{"gmean"}.
Switch to arithmetic formula if \code{opt.mean = "amean"}.
Switch to geometric formula if \code{opt.mean = "gmean"}.}

\item{opt.hor}{a logical.
If \code{opt.hor = TRUE},
boxplot is plotted as horizontal boxes
alongside a vertical y-axis of performances.
If \code{opt.hor = FALSE},
boxplot is plotted as vertical boxes
alongside a horizontal y-axis of performances.}
}
\value{
Nothing. It is a procedure.
}
\description{
Plot performances of assembly motifs as boxplots,
possibly horizontally or vertically,
by decreasing or increasing values.
}
\details{
None.
}
\keyword{internal}
