% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify_column_groups.R
\name{verify_column_groups}
\alias{verify_column_groups}
\title{Verify the integrity of the column groups object}
\usage{
verify_column_groups(column_groups, column_info)
}
\arguments{
\item{column_groups}{A data frame describing of how to group the columns
in \code{column_info}. Can consist of the following columns:
\itemize{
\item \code{group} (\code{character}): The corresponding group in \code{column_info$group}.
\item \code{palette} (\code{character}, optional): The palette used to colour the
column group backgrounds.
\item \code{level1} (\code{character}): The label at the highest level.
\item \code{level2} (\code{character}, optional): The label at the middle level.
\item \code{level3} (\code{character}, optional): The label at the lowest level
(not recommended).
}}

\item{column_info}{A data frame describing which columns in \code{data} to
plot. This data frame should contain the following columns:
\itemize{
\item \code{id} (\code{character}): The corresponding column name in \code{data}.
\item \code{name} (\code{character}): A label for the column. If \code{NA} or \code{""},
no label will be plotted. If this column is missing, \code{id} will
be used to generate the \code{name} column.
\item \code{geom} (\code{character}): The geom of the column. Must be one of:
\code{"funkyrect"}, \code{"circle"}, \code{"rect"}, \code{"bar"}, \code{"pie"}, or \code{"text"}.
For \code{"text"}, the corresponding column in \code{data} must be a \code{character}.
For \code{"pie"}, the column must be a list of named numeric vectors.
For all other geoms, the column must be a \code{numeric}.
\item \code{group} (\code{character}): The grouping id of each column, must match with
\code{column_groups$group}. If this column is missing or all values are \code{NA},
columns are assumed not to be grouped.
\item \code{palette} (\code{character}): Which palette to colour the geom by.
Each value should have a matching value in \code{palettes$palette}.
\item \code{options} (\code{list}): Column specific options. The content of the list
will depend on the geom. Options are:
\itemize{
\item \code{width}: Custom width for this column (default: 1).
\item \code{overlay}: Whether to overlay this column over the previous column.
If so, the width of that column will be inherited.
\item \code{legend}: Whether or not to add a legend for this column.
\item \code{hjust}, \code{vjust}, \code{size}: see \link[ggplot2:geom_text]{ggplot2::geom_text}.
\item \code{label}: Which column to use as a label (only for \code{geom = "text"}).
\item \code{hjust}: Horizontal alignment of the bar, must be between [0,1]
(only for \code{geom = "bar"}).
}
}}
}
\value{
The column groups object with all expected columns.
}
\description{
Verify the integrity of the column groups object
}
\examples{
library(tibble)
column_groups <- tribble(
  ~group, ~level1,
  "foo", "Foo",
  "bar", "Bar"
)
column_info <- tribble(
  ~id, ~geom, ~group,
  "name", "text", NA_character_,
  "foo1", "funkyrect", "foo",
  "foo2", "funkyrect", "foo",
  "bar1", "funkyrect", "bar",
  "bar2", "funkyrect", "bar"
)
verify_column_groups(column_groups, column_info)
}
