% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniqueness.R
\name{uniqueness_stack}
\alias{uniqueness_stack}
\alias{uniqueness_tidy}
\title{Functional Uniqueness on stacked data.frame}
\usage{
uniqueness_stack(com_df, sp_col, dist_matrix)

uniqueness_tidy(com_df, sp_col, dist_matrix)
}
\arguments{
\item{com_df}{a data frame of the species in the regional pool.}

\item{sp_col}{a character vector indicating the name of the species column
in the \code{com_df} data frame}

\item{dist_matrix}{a functional distance matrix}
}
\value{
A data.frame with uniqueness value per species, with one column with
provided species column name and the \strong{Ui} column with the uniqueness
values.
}
\description{
Computes functional uniqueness values over a given regional pool. Functional
uniqueness gives the functional distance to the nearest-neighbor of a given
species in the provided distance matrix. See \code{\link[=uniqueness]{uniqueness()}} function for
details on computation. You can either use \verb{_stack()} or \verb{_tidy()} functions
as they are aliases of one another.
}
\examples{
data("aravo", package = "ade4")

# Site-species matrix converted into data.frame
mat = as.matrix(aravo$spe)
dat = matrix_to_stack(mat, "value", "site", "species")
dat$site = as.character(dat$site)
dat$species = as.character(dat$species)

# Example of trait table
tra = aravo$traits[, c("Height", "SLA", "N_mass")]
# Distance matrix
dist_mat = compute_dist_matrix(tra)

ui_df = uniqueness_stack(dat, "species", dist_mat)
head(ui_df)

}
\seealso{
\code{\link[=uniqueness]{uniqueness()}} and \code{vignette("rarity_indices", package = "funrar")} for
details on the uniqueness metric; \code{\link[=distinctiveness_stack]{distinctiveness_stack()}},
\code{\link[=restrictedness_stack]{restrictedness_stack()}}, \code{\link[=scarcity_stack]{scarcity_stack()}}
}
