% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StEPS_functions.r
\name{FMGM_StEPS}
\alias{FMGM_StEPS}
\title{StEPS: train subsamples and calculate edge instabilities}
\usage{
FMGM_StEPS(
  data,
  ind_disc,
  group,
  lambda_list,
  with_prior = FALSE,
  prior_list = NULL,
  N = 20,
  b = NULL,
  gamma = 0.05,
  perm = 10000,
  eps = 0.05,
  tol_polish = 1e-12,
  ...,
  cores = parallel::detectCores(),
  verbose = FALSE
)
}
\arguments{
\item{data}{Data frame with rows as observations and columns as variables}

\item{ind_disc}{Indices of discrete variables}

\item{group}{Group indices, must be provided with the observation names}

\item{lambda_list}{Vector with numeric variables. Penalization parameter candidates}

\item{with_prior}{Logical. Is prior information provided? Default: FALSE}

\item{prior_list}{List of prior information. Each element must be a 3-column data frames, with the 1st and the 2nd columns being variable names and the 3rd column being prior confidence (0,1)}

\item{N}{Integer. Number of subsamples to use. Default: 20}

\item{b}{Integer. Number of observations in each subsample. Default: ceiling(10*sqrt(number of total observations))}

\item{gamma}{Numeric. Instability cutoff. Default: 0.05}

\item{perm}{Integer. Number of permutations to normalize the prior confidence. Default: 10000}

\item{eps}{Numeric. Pseudocount to calculate the likelihood of edge detection. Default: 0.05}

\item{tol_polish}{Numeric. Cutoff of polishing the resulting network. Default: 1e-12}

\item{...}{Other arguments sent to fast proximal gradient method}

\item{cores}{Integer. Number of cores to use multi-core utilization. Default: maximum number of available cores}

\item{verbose}{Logical. If TRUE, the procedures are reported in real-time manner. Default: FALSE}
}
\value{
The resulting networks, in the form of a list of MGMs
}
\description{
From large to small values of candidates, calculate the edge inference instabilities from subsamples
The smallest values with the instabilities under the cutoff are chosen.
See Sedgewich et al. (2016) for more details
}
\examples{
\donttest{
data(data_all) ;  # Example 500-by-100 simulation data
data(ind_disc) ;

group <- rep(c(1,2), each=250) ;
names(group) <- seq(500) ;

if (Sys.info()['sysname'] == 'Windows') {
  cores=1
} else {
  cores=parallel::detectCores() ;
}

lambda_list <- 2^seq(log2(.08), log2(.32), length.out=7) ;
lambda_list <- sort(lambda_list, decreasing=TRUE) ;

res_steps <- FMGM_StEPS(data_all, ind_disc, group, 
                    lambda_list=lambda_list, 
                    cores=cores, verbose=TRUE)
}
}
