% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_description.R
\name{fill_description}
\alias{fill_description}
\title{Fill DESCRIPTION file of the package}
\usage{
fill_description(pkg = ".", fields, overwrite = FALSE)
}
\arguments{
\item{pkg}{Path to package}

\item{fields}{A named list of fields to add to DESCRIPTION, potentially
overriding default values. See \code{\link[usethis]{use_description}} for how you can set
personalized defaults using package options}

\item{overwrite}{Whether to overwrite existing DESCRIPTION}
}
\value{
FIll DESCRIPTION file with fields. Return path to file.
}
\description{
Fill DESCRIPTION file of the package
}
\examples{
# Create a new project
tmpdir <- tempdir()
dummypackage <- file.path(tmpdir, "dummypackage")
dir.create(dummypackage)

fill_description(
  pkg = dummypackage,
  fields = list(
    Title = "Build A Package From Rmarkdown file",
    Description = paste("Use Rmd First method to build your package.",
                        "Start your package with documentation.",
                        "Everything can be set from a Rmarkdown file in your project."),
    `Authors@R` = c(
      person("Sebastien", "Rochette", email = "sebastien@thinkr.fr",
             role = c("aut", "cre"), comment = c(ORCID = "0000-0002-1565-9313")),
      person(given = "ThinkR", role = "cph")
    )
  )
)

# Delete dummy package
unlink(dummypackage, recursive = TRUE)
}
