% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterFuture-class.R,
%   R/MultisessionFuture-class.R
\name{ClusterFuture-class}
\alias{ClusterFuture-class}
\alias{ClusterFuture}
\alias{MultisessionFuture}
\alias{MultisessionFuture-class}
\title{A cluster future is a future whose value will be resolved asynchronously in a parallel process}
\usage{
ClusterFuture(
  expr = NULL,
  envir = parent.frame(),
  substitute = FALSE,
  globals = TRUE,
  packages = NULL,
  local = !persistent,
  gc = FALSE,
  persistent = FALSE,
  workers = NULL,
  user = NULL,
  master = NULL,
  revtunnel = TRUE,
  homogeneous = TRUE,
  ...
)

MultisessionFuture(
  expr = NULL,
  envir = parent.frame(),
  substitute = FALSE,
  globals = TRUE,
  persistent = FALSE,
  local = !persistent,
  workers = NULL,
  ...
)
}
\arguments{
\item{expr}{An \R \link[base]{expression}.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{globals}{(optional) a logical, a character vector, or a named list
to control how globals are handled.
For details, see section 'Globals used by future expressions'
in the help for \code{\link{future}()}.}

\item{packages}{(optional) a character vector specifying packages
to be attached in the \R environment evaluating the future.}

\item{local}{If TRUE, the expression is evaluated such that
all assignments are done to local temporary environment, otherwise
the assignments are done to the global environment of the \R process
evaluating the future.}

\item{gc}{If TRUE, the garbage collector run (in the process that
evaluated the future) only after the value of the future is collected.
Exactly when the values are collected may depend on various factors such
as number of free workers and whether \code{earlySignal} is TRUE (more
frequently) or FALSE (less frequently).
\emph{Some types of futures ignore this argument.}}

\item{persistent}{If FALSE, the evaluation environment is cleared
from objects prior to the evaluation of the future.}

\item{workers}{A \code{\link[parallel:makeCluster]{cluster}} object,
a character vector of host names, a positive numeric scalar,
or a function.
If a character vector or a numeric scalar, a \code{cluster} object
is created using \code{\link{makeClusterPSOCK}(workers)}.
If a function, it is called without arguments \emph{when the future
is created} and its value is used to configure the workers.
The function should return any of the above types.}

\item{user}{(optional) The user name to be used when communicating
with another host.}

\item{master}{(optional) The hostname or IP address of the master
machine running this node.}

\item{revtunnel}{If TRUE, reverse SSH tunneling is used for the
PSOCK cluster nodes to connect back to the master \R process.  This
avoids the hassle of firewalls, port forwarding and having to know
the internal / public IP address of the master \R session.}

\item{homogeneous}{If TRUE, all cluster nodes is assumed to use the
same path to \file{Rscript} as the main \R session.  If FALSE, the
it is assumed to be on the PATH for each node.}

\item{...}{Additional named elements passed to \code{\link{Future}()}.}
}
\value{
\code{ClusterFuture()} returns an object of class \code{ClusterFuture}.

\code{MultisessionFuture()} returns an object of class
\code{MultisessionFuture}, which inherits from \code{ClusterFuture}.
}
\description{
A cluster future is a future whose value will be resolved asynchronously in a parallel process
}
\seealso{
To evaluate an expression using "cluster future", see function
\code{\link{cluster}()}.
}
\keyword{internal}
