% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-options.R
\name{zzz-future.options}
\alias{zzz-future.options}
\alias{future.options}
\alias{future.startup.script}
\alias{future.debug}
\alias{future.demo.mandelbrot.region}
\alias{future.demo.mandelbrot.nrow}
\alias{future.fork.multithreading.enable}
\alias{future.globals.maxSize}
\alias{future.globals.method}
\alias{future.globals.onMissing}
\alias{future.globals.resolve}
\alias{future.globals.onReference}
\alias{future.plan}
\alias{future.onFutureCondition.keepFuture}
\alias{future.resolve.recursive}
\alias{future.connections.onMisuse}
\alias{future.devices.onMisuse}
\alias{future.globalenv.onMisuse}
\alias{future.rng.onMisuse}
\alias{future.wait.alpha}
\alias{future.wait.interval}
\alias{future.wait.timeout}
\alias{future.output.windows.reencode}
\alias{future.journal}
\alias{future.globals.objectSize.method}
\alias{R_FUTURE_STARTUP_SCRIPT}
\alias{R_FUTURE_DEBUG}
\alias{R_FUTURE_DEMO_MANDELBROT_REGION}
\alias{R_FUTURE_DEMO_MANDELBROT_NROW}
\alias{R_FUTURE_FORK_MULTITHREADING_ENABLE}
\alias{R_FUTURE_GLOBALS_MAXSIZE}
\alias{R_FUTURE_GLOBALS_METHOD}
\alias{R_FUTURE_GLOBALS_ONMISSING}
\alias{R_FUTURE_GLOBALS_RESOLVE}
\alias{R_FUTURE_GLOBALS_ONREFERENCE}
\alias{R_FUTURE_PLAN}
\alias{R_FUTURE_ONFUTURECONDITION_KEEPFUTURE}
\alias{R_FUTURE_RESOLVE_RECURSIVE}
\alias{R_FUTURE_CONNECTIONS_ONMISUSE}
\alias{R_FUTURE_DEVICES_ONMISUSE}
\alias{R_FUTURE_GLOBALENV_ONMISUSE}
\alias{R_FUTURE_RNG_ONMISUSE}
\alias{R_FUTURE_WAIT_ALPHA}
\alias{R_FUTURE_WAIT_INTERVAL}
\alias{R_FUTURE_WAIT_TIMEOUT}
\alias{R_FUTURE_RESOLVED_TIMEOUT}
\alias{R_FUTURE_OUTPUT_WINDOWS_REENCODE}
\alias{R_FUTURE_JOURNAL}
\alias{R_FUTURE_GLOBALS_OBJECTSIZE_METHOD}
\alias{future.cmdargs}
\alias{.future.R}
\title{Options used for futures}
\description{
Below are the \R options and environment variables that are used by the
\pkg{future} package and packages enhancing it.\cr
\cr
\emph{WARNING: Note that the names and the default values of these options may
change in future versions of the package.  Please use with care until
further notice.}
}
\section{Packages must not change future options}{


Just like for other R options, as a package developer you must \emph{not} change
any of the below \verb{future.*} options.  Only the end-user should set these.
If you find yourself having to tweak one of the options, make sure to
undo your changes immediately afterward.  For example, if you want to
bump up the \code{future.globals.maxSize} limit when creating a future,
use something like the following inside your function:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{oopts <- options(future.globals.maxSize = 1.0 * 1e9)  ## 1.0 GB
on.exit(options(oopts))
f <- future(\{ expr \})  ## Launch a future with large objects
}\if{html}{\out{</div>}}
}

\section{Settings moved to the 'parallelly' package}{

Several functions have been moved to the \pkg{parallelly} package:
\itemize{
\item \code{\link[parallelly:availableCores]{parallelly::availableCores()}}
\item \code{\link[parallelly:availableWorkers]{parallelly::availableWorkers()}}
\item \code{\link[parallelly:makeClusterMPI]{parallelly::makeClusterMPI()}}
\item \code{\link[parallelly:makeClusterPSOCK]{parallelly::makeClusterPSOCK()}}
\item \code{\link[parallelly:makeClusterPSOCK]{parallelly::makeNodePSOCK()}}
\item \code{\link[parallelly:supportsMulticore]{parallelly::supportsMulticore()}}
}

The options and environment variables controlling those have been adjusted
accordingly to have different prefixes.
For example, option \option{future.fork.enable} has been renamed to
\option{parallelly.fork.enable} and the corresponding environment variable
\env{R_FUTURE_FORK_ENABLE} has been renamed to
\env{R_PARALLELLY_FORK_ENABLE}.
For backward compatibility reasons, the \pkg{parallelly} package will
support both versions for a long foreseeable time.
See the \link[parallelly:parallelly.options]{parallelly::parallelly.options} page for the settings.
}

\section{Options for controlling futures}{

\describe{
\item{\option{future.plan}:}{(character string or future function) Default future strategy plan used unless otherwise specified via \code{\link[=plan]{plan()}}. This will also be the future plan set when calling \code{plan("default")}.  If not specified, this option may be set when the \pkg{future} package is \emph{loaded} if command-line option \code{--parallel=ncores} (short \verb{-p ncores}) is specified; if \code{ncores > 1}, then option \option{future.plan} is set to \code{multisession} otherwise \code{sequential} (in addition to option \option{mc.cores} being set to \code{ncores}, if \code{ncores >= 1}). (Default: \code{sequential})}

\item{\option{future.globals.maxSize}:}{(numeric) Maximum allowed total size (in bytes) of global variables identified. This is used to protect against exporting too large objects to parallel workers by mistake. Transferring large objects over a network, or over the internet, can be slow and therefore introduce a large bottleneck that increases the overall processing time. It can also result in large egress or ingress costs, which may exist on some systems. If set of \code{+Inf}, then the check for large globals is skipped. (Default: \code{500 * 1024 ^ 2} = 500 MiB)}

\item{\option{future.globals.onReference}: (\emph{beta feature - may change})}{(character string) Controls whether the identified globals should be scanned for so called \emph{references} (e.g. external pointers and connections) or not.  It is unlikely that another \R process ("worker") can use a global that uses a internal reference of the master \R process---we call such objects \emph{non-exportable globals}.
If this option is \code{"error"}, an informative error message is produced if a non-exportable global is detected.
If \code{"warning"}, a warning is produced, but the processing will continue; it is likely that the future will be resolved with a run-time error unless processed in the master \R process (e.g. \code{plan(sequential)} and \code{plan(multicore)}).
If \code{"ignore"}, no scan is performed.
(Default: \code{"ignore"} but may change)
}

\item{\option{future.resolve.recursive}:}{(integer) An integer specifying the maximum recursive depth to which futures should be resolved. If negative, nothing is resolved.  If \code{0}, only the future itself is resolved.  If \code{1}, the future and any of its elements that are futures are resolved, and so on. If \code{+Inf}, infinite search depth is used. (Default: \code{0})}

\item{\option{future.rng.onMisuse}: (\emph{beta feature - may change})}{(character string) If random numbers are used in futures, then parallel (L'Ecuyer-CMRG) RNG should be used in order to get statistical sound RNGs. The defaults in the future framework assume that \emph{no} random number generation (RNG) is taken place in the future expression because L'Ecuyer-CMRG RNGs come with an unnecessary overhead if not needed.  To protect against mistakes, the future framework attempts to detect when random numbers are used despite L'Ecuyer-CMRG RNGs are not in place.  If this is detected, and \code{future.rng.onMisuse = "error"}, then an informative error message is produced.  If \code{"warning"}, then a warning message is produced.  If \code{"ignore"}, no check is performed. (Default: \code{"warning"})}

\item{\option{future.connections.onMisuse}: (\emph{beta feature - may change})}{(character string) A future must close any connections it opens and must not close connections it did not open. If such misuse is detected and this option is set to \code{"error"}, \code{value()} will produce an error with details. If it is set to \code{"warning"}, a warning is produced. If \code{"ignore"}, no check is performed. (Default: \code{"warning"})}

\item{\option{future.globalenv.onMisuse}: (\emph{beta feature - may change})}{(character string) Assigning variables to the global environment for the purpose of using the variable at a later time makes no sense with futures, because the next future may be evaluated in different R process.  To protect against mistakes, the future framework attempts to detect when variables are added to the global environment.  If this is detected, and \code{future.globalenv.onMisuse = "error"}, then an informative error message is produced.  If \code{"warning"}, then a warning message is produced.  If \code{"ignore"}, no check is performed. (Default: \code{"ignore"})}

\item{\option{future.onFutureCondition.keepFuture}:}{(logical) If \code{TRUE}, a \code{FutureCondition} keeps a copy of the \code{Future} object that triggered the condition. If \code{FALSE}, it is dropped. (Default: \code{TRUE})}

\item{\option{future.wait.timeout}:}{(numeric) Maximum waiting time (in seconds) for a future to resolve or for a free worker to become available before a timeout error is generated. (Default: \code{30 * 24 * 60 * 60} (= 30 days))}

\item{\option{future.wait.interval}:}{(numeric) Initial interval (in
seconds) between polls. This controls the polling frequency for finding
an available worker when all workers are currently busy. It also controls
the polling frequency of \code{resolve()}. (Default: \code{0.01} = 1 ms)}

\item{\option{future.wait.alpha}:}{(numeric) Positive scale factor used to increase the interval after each poll. (Default: \code{1.01})}
}
}

\section{Options for debugging futures}{

\describe{
\item{\option{future.debug}:}{(logical) If \code{TRUE}, extensive debug messages are generated. (Default: \code{FALSE})}
}
}

\section{Options for controlling package startup}{

\describe{
\item{\option{future.startup.script}:}{(character vector or a logical) Specifies zero of more future startup scripts to be sourced when the \pkg{future} package is \emph{attached}. It is only the first existing script that is sourced. If none of the specified files exist, nothing is sourced---there will be neither a warning nor an error.
If this option is not specified, environment variable \env{R_FUTURE_STARTUP_SCRIPT} is considered, where multiple scripts may be separated by either a colon (\code{:}) or a semicolon (\verb{;}). If neither is set, or either is set to \code{TRUE}, the default is to look for a \file{.future.R} script in the current directory and then in the user's home directory.  To disable future startup scripts, set the option or the environment variable to \code{FALSE}.  \emph{Importantly}, this option is \emph{always} set to \code{FALSE} if the \pkg{future} package is loaded as part of a future expression being evaluated, e.g. in a background process. In order words, they are sourced in the main \R process but not in future processes. (Default: \code{TRUE} in main \R process and \code{FALSE} in future processes / during future evaluation)}

\item{\option{future.cmdargs}:}{(character vector) Overrides \code{\link[base]{commandArgs}()} when the \pkg{future} package is \emph{loaded}.}
}
}

\section{Options for configuring low-level system behaviors}{


\describe{
\item{\option{future.fork.multithreading.enable} (\emph{beta feature - may change}):}{(logical) Enable or disable \emph{multi-threading} while using \emph{forked} parallel processing.  If \code{FALSE}, different multi-thread library settings are overridden such that they run in single-thread mode. Specifically, multi-threading will be disabled for OpenMP (which requires the \pkg{RhpcBLASctl} package) and for \strong{RcppParallel}. If \code{TRUE}, or not set (the default), multi-threading is allowed.  Parallelization via multi-threaded processing (done in native code by some packages and external libraries) while at the same time using forked (aka "multicore") parallel processing is known to unstable.  Note that this is not only true when using \code{plan(multicore)} but also when using, for instance, \code{\link[=mclapply]{mclapply}()} of the \pkg{parallel} package. (Default: not set)}

\item{\option{future.output.windows.reencode}:}{(logical) Enable or disable re-encoding of UTF-8 symbols that were incorrectly encoded while captured.  In R (< 4.2.0) and on older versions of MS Windows, R cannot capture UTF-8 symbols as-is when they are captured from the standard output.  For examples, a UTF-8 check mark symbol (\code{"\\u2713"}) would be relayed as \code{"<U+2713>"} (a string with eight ASCII characters).  Setting this option to \code{TRUE} will cause \code{value()} to attempt to recover the intended UTF-8 symbols from \verb{<U+nnnn>} string components, if, and only if, the string was captured by a future resolved on MS Windows. (Default: \code{TRUE})}
}

See also \link[parallelly:parallelly.options]{parallelly::parallelly.options}.
}

\section{Options for demos}{

\describe{
\item{\option{future.demo.mandelbrot.region}:}{(integer) Either a named list of \code{\link[=mandelbrot]{mandelbrot()}} arguments or an integer in \{1, 2, 3\} specifying a predefined Mandelbrot region. (Default: \code{1L})}

\item{\option{future.demo.mandelbrot.nrow}:}{(integer) Number of rows and columns of tiles. (Default: \code{3L})}
}
}

\section{Deprecated or for internal prototyping}{


The following options exists only for troubleshooting purposes and must not
be used in production.  If used, there is a risk that the results are
non-reproducible if processed elsewhere.  To lower the risk of them being
used by mistake, they are marked as deprecated and will produce warnings
if set.

\describe{
\item{\option{future.globals.onMissing}:}{(character string) Action to take when non-existing global variables ("globals" or "unknowns") are identified when the future is created.  If \code{"error"}, an error is generated immediately.  If \code{"ignore"}, no action is taken and an attempt to evaluate the future expression will be made.  The latter is useful when there is a risk for false-positive globals being identified, e.g. when future expression contains non-standard evaluation (NSE).  (Default: \code{"ignore"})}

\item{\option{future.globals.method}:}{(character string) Method used to identify globals. For details, see \code{\link[globals]{globalsOf}()}. (Default: \code{"ordered"})}

\item{\option{future.globals.resolve}:}{(logical) If \code{TRUE}, globals that are \code{\link{Future}} objects (typically created as \emph{explicit} futures) will be resolved and have their values (using \code{value()}) collected.  Because searching for unresolved futures among globals (including their content) can be expensive, the default is not to do it and instead leave it to the run-time checks that assert proper ownership when resolving futures and collecting their values. (Default: \code{FALSE})}
}
}

\section{Environment variables that set R options}{

All of the above \R \option{future.*} options can be set by corresponding
environment variable \env{R_FUTURE_*} \emph{when the \pkg{future} package is
loaded}. This means that those environment variables must be set before
the \pkg{future} package is loaded in order to have an effect.
For example, if \code{R_FUTURE_RNG_ONMISUSE="ignore"}, then option
\option{future.rng.onMisuse} is set to \code{"ignore"} (character string).
Similarly, if \code{R_FUTURE_GLOBALS_MAXSIZE="50000000"}, then option
\option{future.globals.maxSize} is set to \code{50000000} (numeric).
}

\examples{
# Allow at most 5 MB globals per futures
options(future.globals.maxSize = 5e6)

# Be strict; catch all RNG mistakes
options(future.rng.onMisuse = "error")


}
\seealso{
To set \R options or environment variables when \R starts (even before the \pkg{future} package is loaded), see the \link[base]{Startup} help page.  The \href{https://cran.r-project.org/package=startup}{\pkg{startup}} package provides a friendly mechanism for configurating \R's startup process.
}
