% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluators.R
\name{fuzz_function}
\alias{fuzz_function}
\alias{p_fuzz_function}
\title{Fuzz-test a function}
\usage{
fuzz_function(fun, arg_name, ..., tests = test_all(), check_args = TRUE,
  progress = interactive())

p_fuzz_function(fun, .l, check_args = TRUE, progress = interactive())
}
\arguments{
\item{fun}{A function.}

\item{arg_name}{Quoted name of the argument to fuzz test.}

\item{...}{Other non-dynamic arguments to pass to \code{fun}. These will be
repeated for every one of the \code{tests}.}

\item{tests}{Which fuzz tests to run. Accepts a named list of inputs,
defaulting to \code{\link{test_all}}.}

\item{check_args}{Check if \code{arg_name} and any arguments passed as
\code{...} are accepted by \code{fun}. Set to \code{FALSE} if you need to
pass arguments to a function that accepts arguments via \code{...}.}

\item{progress}{Show a progress bar while running tests?}

\item{.l}{A named list of tests.}
}
\value{
A \code{fuzz_results} object.
}
\description{
Evaluate how a function responds to unexpected or non-standard inputs.
}
\details{
\code{fuzz_function} provides a simple interface to fuzz test a single
argument of a function by passing the function, name of the argument, static
values of other required arguments, and a named list of test values.

\code{p_fuzz_function} takes a nested list of arguments paired with lists of
tests to run on each argument, and will evaluate every combination of
argument and provided test.
}
\note{
The user will be asked to confirm before proceeding if the combinations
  of potential tests exceeds 500,000.
}
\examples{
# Evaluate the 'formula' argument of lm, passing additional required variables
fr <- fuzz_function(lm, "formula", data = iris)

# When evaluating a function that takes ..., set check_args to FALSE
fr <- fuzz_function(paste, "x", check_args = FALSE)

# Pass tests to multiple arguments via a named list
test_args <- list(
   data = test_df(),
   subset = test_all(),
   # Specify custom tests with a new named list
   formula = list(all_vars = Sepal.Length ~ ., one_var = mpg ~ .))
fr <- p_fuzz_function(lm, test_args)
}
\seealso{
\code{\link{fuzz_results}} and
  \code{\link{as.data.frame.fuzz_results}} to access fuzz test results.
}

